#include <iostream>
#include <list>
#include <string>
#include <algorithm>

using namespace std;

// prosty funktor wypisujcy elementy
template<typename T>
struct printer {
   void operator()(const T& s) {
      cout << s << '\n';
   }
};

bool inline even(int n) {
   return(n % 2 == 0);
}

printer<string> strPrinter;
printer<int>    intPrinter;

int main( ) {

   list<string> lstOne;
   list<string> lstTwo;

   lstOne.push_back("Czerwony");
   lstOne.push_back("Zielony");
   lstOne.push_back("Niebieski");

   lstTwo.push_front("Pomaraczowy");
   lstTwo.push_front("ty");
   lstTwo.push_front("Fuksja");

   for_each(lstOne.begin( ), // wypisanie elementw listy za
            lstOne.end( ),   // pomoc wasnego funktora
            strPrinter);

   lstOne.sort( );           // lista ma metod realizujc
   lstTwo.sort( );           // sortowanie elementw

   lstOne.merge(lstTwo);     // zcalenie dwch list i wypisanie wyniku
   for_each(lstOne.begin( ), // (przed scaleniem listy trzeba
            lstOne.end( ),   // posortowa)
            strPrinter);

   list<int> intLst;

   intLst.push_back(0);
   intLst.push_back(1);
   intLst.push_back(2);
   intLst.push_back(3);
   intLst.push_back(4);

   // usnicie wszystkich elementw o wartociach wikszych od 2
   intLst.remove_if(bind2nd(greater<int>( ), 2));

   for_each(intLst.begin( ),
            intLst.end( ),
            intPrinter);

   // albo usunicie wszystkich elementw o wartociach parzystych
   intLst.remove_if(even);
}
