#include <fstream>
#include <iostream>
#include <vector>

using namespace std;

int main ()
{
      fstream plik ( "wyniki.txt", ios::in | ios::out );
      if ( ! plik.is_open() )
      {
            cout << "Nie moglem otworzyc pliku!" << '\n';
            return 0;
      }
      int nowy_wynik;
      cout << "Podaj nowy wynik: ";
      cin >> nowy_wynik;

      // Ponizsza petla przeszukuje plik, az natrafi na wartosc,
      // ktora jest mniejsza od biezacego wyniku; to wlasnie w tym
      // miejscu, tuz przed znaleziona wartoscia bedziemy chcieli
      // wstawic nowy wynik. Aby zagwarantowac, ze nasza pozycja
      // jest dobra, w zmiennej poprz_poz_wyniku przechowujemy
      // pozycje poprzedzajaca biezaca punktacje
      streampos poprz_poz_wyniku = plik.tellg();
      int biez_wynik;
      while ( plik >> biez_wynik )
      {
            if ( biez_wynik < nowy_wynik )
            {
                  break;
            }
            poprz_poz_wyniku = plik.tellg();
      }

      // Jesli fail zwroci prawde, a my nie znajdujemy sie na koncu pliku,
      // to znaczy, ze dane byly bledne
      if ( plik.fail() && ! plik.eof() )
      {
            cout << "Niepoprawny odczyt wyniku--wychodze z programu";
            return 0;
      }
      // Bez wywolania clear, nie moglibysmy zapisywac do pliku,
      // gdybysmy natrafili na eof
      plik.clear();

      // Wracamy do miejsca znajdujacego sie tuz przed odczytem ostatniego
      // wyniku, abysmy mogli wczytac wszystkie wyniki, ktore sa mniejsze
      // od wyniku podanego przez uzytkownika i przeniesc je w pliku
      // o jedno miejsce dalej
      plik.seekg( poprz_poz_wyniku );

      // Teraz wczytamy wszystkie wyniki, poczawszy od wyniku,
      // ktory wczytalismy poprzednio
      vector<int> punktacja;
      while ( plik >> biez_wynik )
      {
            punktacja.push_back( biez_wynik );
      }
      // W tej petli spodziewamy sie konca pliku, poniewaz chcemy
      // odczytac wszystkie zapisane wyniki
      if ( ! plik.eof() )
      {
            cout << "Niepoprawny odczyt wyniku--wychodze z programu";
            return 0;
      }
      // Poniewaz dotarlismy do konca pliku, znowu musimy wywolac clear,
      // abysmy mogli w tym pliku zapisywac
      plik.clear();

      // Wracamy na pozycje, w ktrej chcemy wstawic nasz wynik
      plik.seekp( poprz_poz_wyniku );
      // Jesli nie zapisujemy na poczatku pliku, bedziemy musieli
      // wstawic nowy wiersz. Robimy to dlatego, ze wczytywanie liczby
      // zatrzymuje sie przy pierwszym bialym znaku, tak wiec pozycja,
      // na ktorej sie znajdujemy przed przystapieniem do zapisywania
      // to koniec liczby a nie poczatek nastepnego wiersza
      if ( poprz_poz_wyniku != std::streampos(0) )
      {
            plik << endl;
      }
      // zapisz nasz nowy wynik
      plik << nowy_wynik << endl;
      // Przechodzimy w petli przez reszte wektora punktacja, zapisujac
      // wszystkie pozostale wyniki
      for ( vector<int>::iterator itr = punktacja.begin(); itr != punktacja.end(); ++itr )
      {
            plik << *itr << endl;
      }
}
