#include <iostream>
#include <cstdlib>


using namespace std;

struct wezel
{
      int wartosc_klucza;
      wezel *w_lewy;
      wezel *w_prawy;
};

wezel* wstaw (wezel *w_drzewo, int klucz)
{
      // Przypadek bazowy - mamy juz puste drzewo
      // i musimy wstawic tu nasz nowy wezel.
      if ( w_drzewo == NULL )
      {
            wezel* w_nowe_drzewo = new wezel;
            w_nowe_drzewo->w_lewy = NULL;
            w_nowe_drzewo->w_prawy = NULL;
            w_nowe_drzewo->wartosc_klucza = klucz;
            return w_nowe_drzewo;
      }
      // W zaleznosci od wartosci wezla zdecyduj, czy wstawiac
      // do lewego, czy do prawego poddrzewa
      if( klucz < w_drzewo->wartosc_klucza )
      {
            // Zbuduj drzewo bazujace na w_drzewo->lewy poprzez dodanie klucza.
            // Nastepnie zastap istniejacy wskaznik w_drzewo->lewy wskaznikiem
            // do nowego drzewa. Musimy skonfigurowac wskaznik w_drzewo->w_lewy
            // na wypadek, gdyby w_drzewo->lewy mial wartosc NULL (jesli nie
            // jest NULL, w_drzewo->w_lewy nie zmieni sie, ale taka
            // konfiguracja i tak nie zaszkodzi).
            w_drzewo->w_lewy = wstaw( w_drzewo->w_lewy, klucz );
      }
      else
      {
            // Wstawianie z prawej strony jest symetryczne wzgledem
            // wstawiania z lewej strony
            w_drzewo->w_prawy = wstaw( w_drzewo->w_prawy, klucz );
      }
      return w_drzewo;
}

wezel *szukaj (wezel *w_drzewo, int klucz)
{
      // Jesli dotrzemy do pustego drzewa, szukanej wartosci na pewno tu nie ma!
      if ( w_drzewo == NULL )
      {
            return NULL;
      }
      // Jesli znajdziemy klucz, konczymy!
      else if ( klucz == w_drzewo->wartosc_klucza )
      {
            return w_drzewo;
      }
      // W przeciwnym razie probujemy szukac w lewym albo prawym poddrzewie
      else if ( klucz < w_drzewo->wartosc_klucza )
      {
            return szukaj( w_drzewo->w_lewy, klucz );
      }
      else
      {
            return szukaj( w_drzewo->w_prawy, klucz );
      }
}

void zniszcz_drzewo (wezel *w_drzewo)
{
      if ( w_drzewo != NULL )
      {
            zniszcz_drzewo( w_drzewo->w_lewy );
            zniszcz_drzewo( w_drzewo->w_prawy );
            cout << "Usuwam wezel: " << w_drzewo->wartosc_klucza;
            delete w_drzewo;
      }
}

wezel* usun_max_wezel (wezel* w_drzewo, wezel* w_max_wezel)
{
      // Kod na wszelki wypadek - warunek ten nigdy nie powinien sie spelnic
      if ( w_drzewo == NULL )
      {
            return NULL;
      }
      // Znalezlismy wezel i mozemy go zastapic
      if ( w_drzewo == w_max_wezel )
      {
            // Robimy to tylko dlatego, ze wiemy, ze
            // w_max_wezel->w_prawy ma wartosc NULL, tak wiec nie tracimy
            // zadnej informacji. Jesli w_max_wezel nie ma lewego poddrzewa,
            // zwrocimy po prostu z tej galezi wartosc NULL, co spowoduje,
            // ze wezel w_max_wezel zostanie zatapiony pustym drzewem,
            // co wlasnie chcemy osiagnac.
            return w_max_wezel->w_lewy;
      }
      // Kazde wywolanie rekurencyjne zastepuje prawe poddrzewo nowym
      // poddrzewem, ktore nie zawiera wezla w_max_wezel.
      w_drzewo->w_prawy = usun_max_wezel( w_drzewo->w_prawy, w_max_wezel );
      return w_drzewo;
}

wezel* znajdz_max (wezel* w_drzewo)
{
      if ( w_drzewo == NULL )
      {
            return NULL;
      }
      if ( w_drzewo->w_prawy == NULL )
      {
            return w_drzewo;
      }
      return znajdz_max( w_drzewo->w_prawy );
}

wezel* usun (wezel* w_drzewo, int klucz)
{
      if ( w_drzewo == NULL )
      {
            return NULL;
      }
      if ( w_drzewo->wartosc_klucza == klucz )
      {
            // Dwa pierwsze przypadki obsluguja wezly bez synow
            // lub z jednym synem
            if ( w_drzewo->w_lewy == NULL )
            {
                  wezel* w_prawe_poddrzewo = w_drzewo->w_prawy;
                  delete w_drzewo;
                  // Jesli nie ma wezlow potomnych, moze tu zostac zwrocona
                  // wartosc NULL, ale przeciez o to nam chodzi
                  return w_prawe_poddrzewo;
            }
            if ( w_drzewo->w_prawy == NULL )
            {
                  wezel* w_lewe_poddrzewo = w_drzewo->w_lewy;
                  delete w_drzewo;
                  // W tym miejscu zawsze zostanie zwrocony wlasciwy wezel,
                  // poniewaz na podstawie poprzedniego warunku wiemy,
                  // ze nie ma on wartosci NULL
                  return w_lewe_poddrzewo;
            }
            wezel* w_max_wezel = znajdz_max( w_drzewo->w_lewy );
            // Poniewaz wezel w_max_wezel pochodzi z lewego poddrzewa,
            // musimy go stamtad usunac, zanim z powrotem polaczymy
            // to drzewo z pozostala reszta drzewa
            w_max_wezel->w_lewy =
                  usun_max_wezel( w_drzewo->w_lewy, w_max_wezel );
            w_max_wezel->w_prawy = w_drzewo->w_prawy;
            delete w_drzewo;
            return w_max_wezel;
      }
      else if ( klucz < w_drzewo->wartosc_klucza )
      {
            w_drzewo->w_lewy = usun( w_drzewo->w_lewy, klucz );
      }
      else
      {
            w_drzewo->w_prawy = usun( w_drzewo->w_prawy, klucz );
      }
      return w_drzewo;
}

void zamien( int& x, int& y)
{
    int tymcz = x;
    x = y;
    y = tymcz;
}

int main ()
{
    int wybor = 0;
    int wartosc_wezla = 0;
    wezel *w_wezel = NULL;

    while (true)
    {
	cout << "Co chcesz zrobic?\n\n1. Dodac wezel\n2. Usunac wezel\n3. Zniszczyc drzewo\n4. Sprawdzic, czy wezel znajduje sie w drzewie\n5. Wyjsc z programu\n";
	cin >> wybor;
	switch (wybor)
	{
	    case 1:
		cout << "Podaj wartosc do wstawienia: ";
		cin >> wartosc_wezla;
		w_wezel = wstaw( w_wezel, wartosc_wezla );
		cout << "\nWartosc " << wartosc_wezla << " dodano do drzewa\n\n";
		break;
	    case 2:
		cout << "Podaj wartosc do usuniecia: ";
		cin >> wartosc_wezla;
		w_wezel = usun( w_wezel, wartosc_wezla );
		cout << "\nWartosc " << wartosc_wezla << " usunieto z drzewa\n\n";
		break;
	    case 3:
		zniszcz_drzewo( w_wezel );
		w_wezel = NULL;
		cout << "\nDrzewo zniszczone\n\n";
		break;
	    case 4:
	    // Przed zadeklarowaniem w_szukany_wezel dodajemy nowy zakres,
	    // zby zmienna ta nie wyciekla poza blok case
	    {
		cout << "Podaj wartosc do sprawdzenia: ";
		cin >> wartosc_wezla;
		wezel* w_szukany_wezel = szukaj( w_wezel, wartosc_wezla );
		if ( w_szukany_wezel != NULL )
		{
		    cout << "\nZnaleziono wezel\n\n";
		}
		else
		{
		    cout << "\nNie znaleziono wezla\n\n";
		}
	    }
	    break;
	    case 5:
		return 0;
	    default:
		cout << "Niepoprawne dane wejsciowe...\n\n";
	}
    }
}
