#include <iostream>
#include "environment.h"

class OfficialEnv : public Environment {
  public:
	void op1()
		{ std::cout << "OfficialEnv::op1" << std::endl; }
};

Environment::Environment()
	{ std::cout << "Utworzono" << std::endl; }

Environment::~Environment()
	{ std:: cout << "Usunito" << std:: endl; }

Environment *Environment::instance_ = 0;

Environment &Environment::instance() {
    if( !instance_ )
        instance_ = new OfficialEnv;
    return *instance_;
}

// Prosty mechanizm czyszczenia pojedynczej instancji. Zwykle
// dziaa, ale nie jest odporny na niewaciwe uycie.
class Destroyer {
  public:
	~Destroyer() { delete Environment::instance_; }
};
namespace {
Destroyer d;
}
