#include <iostream>

// Zdefiniowa tylko jedno z poniszych!
//#define PTRPTR
#define REFPTR

#ifdef PTRPTR

// get_token zwraca wskanik na nastpny cig znakw
// ograniczonych przez znaki z ws.
// Wskanik parametru jest aktualizowany w celu wskazania
// zwrconej danej.
// Pusty znak (NUL) jest wstawiany do s po znalezionym cigu.
// Spacje kocowe daj element pusty.
char *get_token( char **s, const char *ws = " \t\n" ) {
    char *p;
    do
        for( p = (char *) ws; *p && **s != *p; p++ );
    while( *p ? *(*s)++ : 0 );
    char *ret = *s;
    do
        for( p = (char *) ws; *p && **s != *p; p++ );
    while( *p ? 0 : **s ? (*s)++ : 0 );
    if( **s ) {
    	**s = '\0';
    	++*s;
    }
    return ret;
}

#endif

#ifdef REFPTR

char *get_token( char *&s, const char *ws = " \t\n" ) {
    char *p;
    do
        for( p = (char *) ws; *p && *s != *p; p++ ); 
    while( *p ? *s++ : 0 );
    char *ret = s;
    do
        for( p = (char *) ws; *p && *s != *p; p++ );
    while( *p ? 0 : *s ? s++ : 0 );
    if( *s ) *s++ = '\0';
    return ret;
}

#endif

extern char *getInputBuffer() {
	static char buf[] = "oto bufor wejciowy";
	return buf;
}

int main() {
	char *tokens = getInputBuffer();
	std::cout << "Bufor wejciowy: |" << tokens << "|" << std::endl;
	//...
	while( *tokens )
#ifdef PTRPTR
    	std::cout << "element: |" << get_token( &tokens ) << '|' << std::endl;
#endif
#ifdef REFPTR
    	std::cout << "element: |" << get_token( tokens ) << '|' << std::endl;
#endif
    
    return 0;
}
