#ifndef EPARSE_H
#define EPARSE_H

#include "e.h"
#include <cstring>
#include <stdio.h>

class Lex {	// interfejs oglnego analizatora leksykograficznego
  public:
	Lex( std::size_t lexeme_size = 81 )
		: str( new char[ lexeme_size ] ) {}
	virtual ~Lex()
		{ delete [] str; }
	virtual void scan() = 0;
	int token() const
		{ return tok; }
	const char *lexeme() const
		{ return str; }
  protected:
	int tok;
	char *str;
};

class CharLex : public Lex {	// odczyt strumienia znakw
  protected:
	// jeli nie nadpisano, odczyt ze stdin
	virtual int nextchar()
		{ return getchar(); }
	virtual void unnextchar( char c )
		{ ungetc( c, stdin ); }
};

class ExprLex : public CharLex {	// dla wyrae
  public:
	void scan();
};

enum { ID = 257, INT, EOLN, BAD };

class Parser {	// interfejs oglnego parsera
  public:
	Parser( Lex *lp )
		: lex( lp ) {}
	virtual ~Parser()
		{ delete lex; }
	virtual E *parse() = 0;
  protected:
	void scan()
		{ lex->scan(); }
	int token() const
		{ return lex->token(); }
	const char *lexeme() const
		{ return lex->lexeme(); }
  private:
	Lex *lex;
};

/*
        Parser prostej gramatyki wyrae

		S --> E eoln
		E --> T {(+|-)T}
		T --> F {(*|/)F}
		F --> id | int | ( E ) | ID = E | -F
*/
class ExprParser : public Parser {
  public :
	ExprParser( Lex *lp )
		: Parser( lp ) {}
	~ExprParser()
		{}
	E *parse();
  private:
	E *s();
	E *e();
	E *t();
	E *f();
	void error();
};

#endif
