#include <algorithm>
#include <vector>
#include <list>
#include <iostream>
using namespace std;

template <typename T>
void DisplayContents (const T& Input)
{
   for(auto iElement = Input.cbegin() // auto i cbegin(): C++11.
      ; iElement != Input.cend() // cend() to nowość w C++11.
      ; ++ iElement )
      cout << *iElement << ' ';

   cout << " | Liczba elementów: " << Input.size() << endl;
}
int main ()
{
    list <int> listIntegers;
    for (int nCount = 0; nCount < 10; ++ nCount)
        listIntegers.push_back (nCount);

    cout << "Elementy w obiekcie źródłowym (list) są następujące: " << endl;
    DisplayContents(listIntegers);

    // Inicjalizacja obiektu vector przeznaczonego do przechowywania dwukrotnie większej liczby elementów niż list.
    vector <int> vecIntegers (listIntegers.size () * 2);

    auto iLastPos = copy ( listIntegers.begin ()  // Początek zakresu źródłowego.
             , listIntegers.end ()      // Koniec zakresu źródłowego.
             , vecIntegers.begin () ); // Początek zakresu docelowego.

    // Kopiujemy liczby nieparzyste z obiektu list do obiektu vector.
   copy_if ( listIntegers.begin(), listIntegers.end()
           , iLastPos
           , [](int element){return ((element % 2) == 1);});

    cout << "Elementy w obiekcie docelowym (vector) po operacji kopiowania są następujące: " << endl;
    DisplayContents(vecIntegers);

    // Usunięcie wszystkich wystąpień elementu '0', i zmiana wielkości obiektu vector przy użyciu algorytmu erase().
    auto iNewEnd = remove (vecIntegers.begin (), vecIntegers.end (), 0);
    vecIntegers.erase (iNewEnd, vecIntegers.end ());

    // Usunięcie z obiektu vector wszystkich liczb nieparzystych za pomocą funkcji remove_if().
    iNewEnd = remove_if (vecIntegers.begin (), vecIntegers.end (), 
              [](int element) {return ((element % 2) == 1);} ); // Predykat.

    vecIntegers.erase (iNewEnd , vecIntegers.end ()); // Zmiana wielkości.

    cout << "Elementy w obiekcie docelowym (vector) po operacji usunięcia są następujące: " << endl;
    DisplayContents(vecIntegers);

    return 0;
}
