#include <algorithm>
#include <string>
#include <vector>
#include <iostream>
using namespace std;

template <typename T>
void DisplayContents (const T& Input)
{
   for(auto iElement = Input.cbegin() // auto, cbegin i cend: c++11.
      ; iElement != Input.cend ()
      ; ++ iElement )
      cout << *iElement << endl;
}

int main ()
{
   // Zdefiniowanie obiektu vector przechowującego ciągi tekstowe zawierające imiona.
   vector <string> vecNames;

   // Wstawienie do zbioru kilku przykładowych imion.
   vecNames.push_back ("jan");
   vecNames.push_back ("Jacek");
   vecNames.push_back ("Stefan");
   vecNames.push_back ("Anna");

   cout << "Imiona w zbiorze wymienione w kolejności wstawiania: " << endl;
   DisplayContents(vecNames);

   cout << "Imiona posortowane przy użyciu domyślnego predykatu std::less<>: " << endl;
   sort(vecNames.begin(), vecNames.end());
   DisplayContents(vecNames); 

   cout << "Imiona posortowane przy użyciu domyślnego predykatu ignorującego wielkość liter:" << endl;
   sort(vecNames.begin(), vecNames.end(),
       [](const string& str1, const string& str2) -> bool  // Wyrażenie lambda.
         {
          string str1LowerCase;

          // Zarezerwowanie miejsca.
          str1LowerCase.resize (str1.size ());

          // Konwersja każdego znaku na mały.
          transform(str1.begin(), str1.end(), str1LowerCase.begin(),tolower);

          string str2LowerCase;
          str2LowerCase.resize (str2.size ());
          transform (str2.begin (), str2.end (), str2LowerCase.begin (),
                     tolower);

          return (str1LowerCase < str2LowerCase);
         }  // Koniec wyrażenia lambda.
      );  // Koniec funkcji sortującej.
   DisplayContents(vecNames);

   return 0;
}
