#include <set>
#include <iostream>
using namespace std;

template <typename T>
void DisplayContents(const T& Input)
{
    for (auto iElement = Input.cbegin() // auto i cbegin() dla C++11.
        ; iElement != Input.cend() // cend() to nowość w C++11.
        ; ++ iElement )
       cout << *iElement << ' '; 

    cout << endl;
}

int main ()
{
    set <int> setIntegers;
    multiset <int> msetIntegers;

    setIntegers.insert (60);
    setIntegers.insert (-1);
    setIntegers.insert (3000);
    cout << "Wyświetlenie na ekranie zawartości obiektu set" << endl;
    DisplayContents(setIntegers);

    msetIntegers.insert (setIntegers.begin (), setIntegers.end ());
    msetIntegers.insert (3000);

    cout << "Wyświetlenie na ekranie zawartości obiektu multiset" << endl;
    DisplayContents(msetIntegers);

    cout << "Liczba wystąpień elementu '3000' w obiekcie multiset wynosi: '";
    cout << msetIntegers.count (3000) << "'" << endl; 

    return 0;
}
