#include <list>
#include <string>
#include <iostream> 
using namespace std;

template <typename T>
void DisplayContents(const T& Input)
{
    for (auto iElement = Input.cbegin() // auto i cbegin() dla C++11.
        ; iElement != Input.cend()
        ; ++ iElement )
       cout << *iElement << ' '; 

    cout << endl;
}

struct ContactItem
{
    string strContactsName;
    string strPhoneNumber; 
    string strDisplayRepresentation;

    // Konstruktor i destruktor.
    ContactItem (const string& strName, const string & strNumber)
    {
        strContactsName = strName;
        strPhoneNumber = strNumber;
        strDisplayRepresentation = (strContactsName + ": " + strPhoneNumber);
    }

    // Operator używany przez list::remove(). 
    bool operator == (const ContactItem& itemToCompare) const
    {
        return (itemToCompare.strContactsName == this->strContactsName);
    }

    // Operator używany przez list::sort() bez parametrów. 
    bool operator < (const ContactItem& itemToCompare) const
    {
        return (this->strContactsName < itemToCompare.strContactsName);
    }

   // Operator używany w DisplayContents() za pomocą polecenia cout.
   operator const char*() const
   {
     return strDisplayRepresentation.c_str();
   }
};

bool SortOnPhoneNumber (const ContactItem& item1, 
                           const ContactItem& item2)
{
   return (item1.strPhoneNumber < item2.strPhoneNumber);
}

int main ()
{
   list <ContactItem> Contacts;
   Contacts.push_back(ContactItem("Jack Welsch", "+1 7889 879 879"));
   Contacts.push_back(ContactItem("Bill Gates", "+1 97 7897 8799 8"));
   Contacts.push_back(ContactItem("Angela Merkel", "+49 23456 5466"));
   Contacts.push_back(ContactItem("Vladimir Putin", "+7 6645 4564 797"));
   Contacts.push_back(ContactItem("Manmohan Singh", "+91 234 4564 789"));
   Contacts.push_back(ContactItem("Barack Obama", "+1 745 641 314"));

   cout << "Lista w kolejności początkowej: " << endl;
   DisplayContents(Contacts);

   Contacts.sort();
   cout << "Po sortowaniu w kolejności alfabetycznej przy użyciu operatora <: " << endl;
   DisplayContents(Contacts);

   Contacts.sort(SortOnPhoneNumber);
   cout << "Po sortowaniu według numeru telefonu przy użyciu predykatu: "<< endl;
   DisplayContents(Contacts);

   cout << "Po usunięciu Putina z listy: ";
   Contacts.remove(ContactItem("Vladimir Putin", ""));
   DisplayContents(Contacts);

}
