#include <list>
#include <iostream>
using namespace std;

template <typename T>
void DisplayContents(const T& Input)
{
    for (auto iElement = Input.cbegin() // auto i cbegin() dla C++11.
        ; iElement != Input.cend()
        ; ++ iElement )
       cout << *iElement << ' '; 

    cout << endl;
}

int main ()
{
    std::list <int> listIntegers;

    // Wstawianie elementów na początku i końcu...
    listIntegers.push_back (4);
    listIntegers.push_front (3);
    listIntegers.push_back (5);

    // Przechowywanie iteratora uzyskanego za pomocą funkcji insert.
    auto iValue2 = listIntegers.insert (listIntegers.begin (), 2);

    cout << "Początkowa zawartość obiektu list:" << endl;
    DisplayContents(listIntegers);

    listIntegers.erase (listIntegers.begin (), iValue2);
    cout << "Zawartość po usunięciu zakresu elementów:" << endl;
    DisplayContents(listIntegers);

    cout << "Zawartość po usunięciu elementu '" << *iValue2 << "':" << endl;
    listIntegers.erase (iValue2);
    DisplayContents(listIntegers);

    listIntegers.erase (listIntegers.begin (), listIntegers.end ());
    cout << "Liczba elementów po usunięciu zakresu:" << endl;
    cout << listIntegers.size() << endl;

    return 0;
}
