#include <algorithm>
#include <vector>
#include <iostream>

// Predykat jednoargumentowy dla funkcji *_if.
template <typename elementType>
bool IsEven (const elementType& number)
{
   return ((number % 2) == 0); // Jeśli liczba jest parzysta, wartością zwrotną będzie true.
}

int main ()
{
   using namespace std;
   vector <int> vecIntegers;

   cout << "Wypełnienie obiektu vector<int> wartościami od -9 do 9" << endl;
   for (int nNum = -9; nNum < 10; ++ nNum)
      vecIntegers.push_back (nNum);

   // Użycie algorytmu count do ustalenia liczby wystąpień '0' w obiekcie vector.
   size_t nNumZeroes = count (vecIntegers.begin (),vecIntegers.end (),0);
   cout << "Liczba wystąpień '0': " << nNumZeroes << endl << endl;

   // Użycie algorytmu count_if wraz z predykatem jednoargumentowym IsEven:
   size_t nNumEvenElements = count_if (vecIntegers.begin (),
                          vecIntegers.end (), IsEven <int> );

   cout << "Liczba elementów parzystych: " << nNumEvenElements << endl;
   cout << "Liczba elementów nieparzystych: ";
   cout << vecIntegers.size () - nNumEvenElements << endl;

   return 0;
}
