#include <string>
#include <algorithm>
#include <iostream>

int main ()
{
    using namespace std;

    string strSample ("Witaj ciągu tekstowy! Obudź się, piękny dzień mamy!");
    cout << "Początkowa postać przykładowego ciągu tekstowego: " << endl;
    cout << strSample << endl << endl;

    // Usunięcie znaków z ciągu tekstowego na podstawie podanego położenia i liczby znaków.
    cout << "Usunięcie drugiego zdania: " << endl;
    strSample.erase (21, 30);
    cout << strSample << endl << endl;

    // Wyszukanie znaku 'c' w ciągu tekstowym przy użyciu algorytmu STL find.
    string::iterator iCharC = find ( strSample.begin ()
                                    , strSample.end (), 'c');

    // Jeżeli znak zostanie znaleziony, funkcja erase() spowoduje usunięcie znaku.
    cout << "Usunięcie znaku 'c' z przykładowego ciągu tekstowego: " << endl;
    if (iCharC != strSample.end ())
        strSample.erase (iCharC);

    cout << strSample << endl << endl;

    // Usunięcie zakresu znaków za pomocą przeciążonej wersji funkcji erase().
    cout << "Usunięcie zakresu znaków od begin() do end(): " << endl;
    strSample.erase (strSample.begin (), strSample.end ());

   // Sprawdzenie długości ciągu po wykonaniu powyższej funkcji erase().
    if (strSample.length () == 0)
        cout << "Ciąg tekstowy jest pusty" << endl;

    return 0;
}
