#include <iostream>
using namespace std;

template <typename T>
class smart_pointer
{
private:
    T* m_pRawPointer;
public:
     smart_pointer (T* pData) : m_pRawPointer (pData) {}    // Konstruktor.
     ~smart_pointer () {delete m_pRawPointer ;}        // Destruktor.

     T& operator* () const    // Operator dereferencji.
     {
         return *(m_pRawPointer);
     }

     T* operator-> () const   // Operator wyboru elementu składowego.
     {
         return m_pRawPointer;
     }
 };

class Date
{
private:
   int Day, Month, Year;
   string DateInString;

public:
   // Konstruktor inicjalizujący obiekt dla dnia, miesiąca i roku..
   Date (int InputDay, int InputMonth, int InputYear)
      : Day (InputDay), Month (InputMonth), Year (InputYear) {};

   void DisplayDate()
   {
      cout << Day << " / " << Month << " / " << Year << endl;
   }
};

int main()
{
   smart_pointer<int> pDynamicInt(new int (42));
   cout << "Dynamicznie zaalokowana liczba całkowita = " << *pDynamicInt;

   smart_pointer<Date> pDate(new Date(25, 12, 2011)); 
   cout << "Data to = ";
   pDate->DisplayDate();

   return 0;
};
