#include <iostream>
#include <memory>  // Ten nagłówek jest wymagany do użycia std::unique_ptr.
using namespace std;

class Fish
{
public:
    Fish() {cout << "Fish: utworzono!" << endl;}
    ~Fish() {cout << "Fish: zniszczono!" << endl;}

    void Swim() const {cout << "Ryba pływa w wodzie" << endl;}
};

void MakeFishSwim(const unique_ptr<Fish>& inFish)
{
   inFish->Swim();
}

int main()
{
   unique_ptr<Fish> smartFish (new Fish);

   smartFish->Swim();
   MakeFishSwim(smartFish); // OK, MakeFishSwim akceptuje referencje.

   unique_ptr<Fish> copySmartFish;
   // copySmartFish = smartFish; // Błąd: operator= jest prywatny.

   return 0;
}
