#include <algorithm>
#include <string>
#include <vector>
#include <deque>
#include <iostream>
#include <functional>

int main ()
{
    using namespace std;

    string Sample ("TO jest TEstowy ciąg tekstowy!");
    cout << "Przykładowy ciąg tekstowy to: " << Sample << endl;

    string strLowerCaseCopy;
    strLowerCaseCopy.resize (Sample.size ());
    
    transform (Sample.begin ()          // Początek zakresu źródłowego.
              , Sample.end ()          // Koniec zakresu źródłowego.
              , strLowerCaseCopy.begin () // Początek zakresu docelowego.
              , tolower );        // Funkcja jednoargumentowa.

    cout << "Wynik użycia algorytmu 'transform' wraz z funkcją 'tolower' względem ciągu tekstowego:" << endl;
    cout << "\"" << strLowerCaseCopy << "\"" << endl << endl;

    // Dwa przykładowe obiekty vector przechowujące liczby całkowite...
    vector <int> vecIntegers1, vecIntegers2;
    for (int nNum = 0; nNum < 10; ++ nNum) 
    {
        vecIntegers1.push_back (nNum);
        vecIntegers2.push_back (10 - nNum);
    }

    // Zakres docelowy przeznaczony do przechowywania wyniku dodawania.
    deque <int> dqResultAddition (vecIntegers1.size ());

    transform ( vecIntegers1.begin ()    // Początek pierwszego zakresu źródłowego.
              , vecIntegers1.end ()      // Koniec pierwszego zakresu źródłowego.
              , vecIntegers2.begin ()    // Początek drugiego zakresu źródłowego.
              , dqResultAddition.begin () // Koniec drugiego zakresu źródłowego.
              , plus <int> () );          // Funkcja dwuargumentowa.

    cout << "Wynik użycia algorytmu 'transform' wraz z funkcją dwuargumentową 'plus': " << endl;
    cout <<endl << "Indeks   Vector1 + Vector2 = Wynik (w Deque)" << endl;
    for (size_t nIndex = 0; nIndex < vecIntegers1.size (); ++ nIndex)
    {
        cout << nIndex << "    \t " << vecIntegers1 [nIndex]  << "\t+   ";
        cout << vecIntegers2 [nIndex]  << " \t  =    ";
        
        cout << dqResultAddition [nIndex] << endl;
    }

    return 0;
}
