#include <map>
#include <iostream>
#include <string>
using namespace std;

template <typename T>
void DisplayContents (const T& Input)
{
   for(auto iElement = Input.cbegin() // auto and cbegin(): C++11.
      ; iElement != Input.cend()  // cend() to nowość w C++11.
      ; ++ iElement )
      cout << iElement->first << " -> " << iElement->second << endl;

   cout << endl;
}

int main ()
{
    multimap<int, string> mmapIntToString;

    // Wstawienie par klucz-wartość do obiektu multimap.
    mmapIntToString.insert (make_pair (3, "Trzy"));
    mmapIntToString.insert (make_pair (45, " Czterdzieści pięć"));
    mmapIntToString.insert (make_pair (-1, "Minus Jeden"));
    mmapIntToString.insert (make_pair (1000, "Tysiąc"));

    // Wstawienie duplikatów do obiektu multimap.
    mmapIntToString.insert (make_pair (-1, "Minus Jeden"));
    mmapIntToString.insert (make_pair (1000, "Tysiąc"));

    cout << "Obiekt multimap zawiera " << mmapIntToString.size ();
    cout << " par(ę/y) klucz-wartość. " << "Pary to: " << endl;
    DisplayContents(mmapIntToString);

    // Usunięcie z obiektu multimap elementu z kluczem -1.
    auto NumPairsErased = mmapIntToString.erase(-1);
    cout<< "Usunięto " << NumPairsErased << " par(y) o kluczu -1."<< endl;

    // Usunięcie z obiektu multimap elementu, do którego prowadzi podany iterator.
    auto iPairLocator = mmapIntToString.find(45);
    if (iPairLocator != mmapIntToString.end ())
    {
        mmapIntToString.erase (iPairLocator);
        cout << "Usunięcie par z kluczem 45 za pomocą iteratora" << endl;
    }

    // Usunięcie z obiektu multimap zakresu elementów...
    cout << "Usunięcie zakresu par z kluczem 1000." << endl;
    mmapIntToString.erase ( mmapIntToString.lower_bound (1000)
        , mmapIntToString.upper_bound (1000) );

    cout << "Obiekt multimap zawiera teraz " << mmapIntToString.size ();
    cout << " par(ę/y) klucz-wartość." << "Pary to: " << endl;
    DisplayContents(mmapIntToString);
    return 0;
}
