#include <list>
#include <iostream>
using namespace std;

bool SortPredicate_Descending (const int& lsh, const int& rsh)
{
   // Zdefiniowanie kryteriów dla list::sort: typ wartości zwrotnej dla sortowania w danej kolejności.
   return (rsh < lsh);
}

template <typename T>
void DisplayContents(const T& Input)
{
    for (auto iElement = Input.cbegin() // auto i cbegin() dla C++11.
        ; iElement != Input.cend()
        ; ++ iElement )
       cout << *iElement << ' '; 

    cout << endl;
}

int main ()
{
    std::list <int> listIntegers;

    // Wstawianie elementów na początku i końcu.
    listIntegers.push_front (444);
    listIntegers.push_front (2011);
    listIntegers.push_front (-1);
    listIntegers.push_front (0);
    listIntegers.push_back (-5);

    cout << "Początkowa zawartość obiektu list -" << endl;
    DisplayContents(listIntegers);

    listIntegers.sort ();

    cout << "Kolejność elementów po użyciu funkcji sort():" << endl;
    DisplayContents(listIntegers);

    listIntegers.sort (SortPredicate_Descending);
    cout << "Kolejność elementów po użyciu funkcji sort() z predykatem:" << endl;
    DisplayContents(listIntegers);

    return 0;
}
