#include <map>
#include <algorithm>
#include <string>
#include <iostream>

using namespace std;

/*
To jest predykat dwuargumentowy, ktry pomaga obiektowi map w sortowaniu
kluczy w postaci cigw tekstowych bez rozrniania wielkoci znakw
*/
struct CCaseInsensitive
{
    bool operator () (const string& str1, const string& str2) const
    {
        string str1NoCase (str1), str2NoCase (str2);
        transform (str1.begin(), str1.end(), str1NoCase.begin(), tolower);
        transform (str2.begin(), str2.end(), str2NoCase.begin(), tolower);

        return (str1NoCase < str2NoCase);
    };
};


// Zdefiniowanie typedef dla definicji obiektu  map w celu zwikszenia czytelnoci...
// Ksika telefoniczna sortujca klucze za pomoc string::operator < (rozrniana wielko znakw)
typedef map <string, string> DIRECTORY_WITHCASE;

// Nie rozrniajca wielkoci znakw definicja ksizki telefonicznej 
typedef map <string, string, CCaseInsensitive> DIRECTORY_NOCASE;

int main ()
{
    // Nie rozrniajca wielkoci znakw ksika telefoniczna: wielko znakw cigu tekstowego nie ma znaczenia
    DIRECTORY_NOCASE dirNoCase;

    dirNoCase.insert (DIRECTORY_NOCASE::value_type ("John", "2345764"));
    dirNoCase.insert (DIRECTORY_NOCASE::value_type ("JOHN", "2345764"));
    dirNoCase.insert (DIRECTORY_NOCASE::value_type ("Sara", "42367236"));
    dirNoCase.insert (DIRECTORY_NOCASE::value_type ("Jack", "32435348"));

    cout << "Wyswietlenie zawartosci obiektu map, ktory nie rozroznia wielkosci znakow:" << endl;

    // Wywietlenie na ekranie zawartoci obiektu map
    DIRECTORY_NOCASE::const_iterator iPairLocator1;
    for ( iPairLocator1 = dirNoCase.begin()
        ; iPairLocator1 != dirNoCase.end()
        ; ++ iPairLocator1 )
    {
        cout << "Imie: " << iPairLocator1->first;
        cout << ", Numer telefonu: " << iPairLocator1->second << endl;
    }

    cout << endl;

    // Ksika telefoniczna rozrniajca wielko znakw: wielko znakw cigu tekstowego klucza
    // ma wpyw na operacje wstawiania i wyszukiwania
    DIRECTORY_WITHCASE dirWithCase;

    // Pobranie wartoci przykadowych z poprzedniego obiektu map...
    dirWithCase.insert ( dirNoCase.begin(), dirNoCase.end() );

    cout << "Wyswietlenie zawartosci obiektu map, ktory rozroznia wielkosc znakow:" << endl;

    // Wywietlenie na ekranie zawartoci obiektu map
    DIRECTORY_WITHCASE::const_iterator iPairLocator2;
    for ( iPairLocator2 = dirWithCase.begin()
        ; iPairLocator2 != dirWithCase.end()
        ; ++ iPairLocator2 )
    {
        cout << "Imie: " << iPairLocator2->first;
        cout << ", Numer telefonu: " << iPairLocator2->second << endl;
    }

    cout << endl;

    // Wyszukanie imienia w tych dwch obiektach map i wywietlenie wynikw operacji
    cout << "Prosze podac imie szukane w obu ksiazkach telefonicznych: " << endl << "> ";
    string strNameInput;
    cin >> strNameInput;

    DIRECTORY_NOCASE::const_iterator iSearchResult1;

    // Wyszukiwanie w obiekcie map...
    iSearchResult1 = dirNoCase.find (strNameInput);
    if (iSearchResult1 != dirNoCase.end())
    {
        cout << "Numer telefonu osoby " <<iSearchResult1->first<< " w ksiazce telefonicznej,";
        cout << " ktora nie rozroznia wielkosci znakow to: " << iSearchResult1->second << endl;
    }
    else
    {
        cout << "Numer telefonu osoby " << strNameInput << " nie zostal znaleziony";
        cout << "w ksiazce telefonicznej, ktora nie rozroznia wielkosci znakow" << endl;
    }

    DIRECTORY_WITHCASE::const_iterator iSearchResult2;

    // Wyszukiwanie w obiekcie map, ktry rozrnia wielko znakw...
    iSearchResult2 = dirWithCase.find (strNameInput);
    if (iSearchResult2 != dirWithCase.end())
    {
        cout<< "Numer telefonu osoby " << iSearchResult2->first<< w ksiazce telefonicznej,";
        cout << " ktora rozroznia wielkosc znakow to: " << iSearchResult2->second << endl;
    }
    else
    {
        cout << "Numer telefonu osoby " << strNameInput << " nie zostal znaleziony";
        cout << " w ksiazce telefonicznej, ktora rozroznia wielkosc znakow" << endl;
    }

    return 0;
}
