#include <iostream>

class CDate
{
  private:
    int m_nDay;    // Zakres: 1 - 30 (zakadamy, e miesice maj po 30 dni!)
    int m_nMonth;    // Zakres: 1 - 12
    int m_nYear;

   void AddDays (int nDaysToAdd)
   {
        m_nDay += nDaysToAdd;

        if (m_nDay > 30)
       {
            AddMonths (m_nDay / 30);

            m_nDay %= 30;    // po przekroczeniu 30-go -> 1-szy
        }
    }

    void AddMonths (int nMonthsToAdd)
    {
        m_nMonth += nMonthsToAdd;

       if (m_nMonth > 12)
       {
           AddYears (m_nMonth / 12);

            m_nMonth %= 12;    // po przekroczeniu grudnia -> stycze
        }
   }

    void AddYears (int m_nYearsToAdd)
    {
        m_nYear += m_nYearsToAdd; 
    }

  public:

   // Konstruktor inicjalizujcy obiekt dla dnia, miesica i roku
    CDate (int nDay, int nMonth, int nYear)
         : m_nDay (nDay), m_nMonth (nMonth), m_nYear (nYear) {};

   CDate operator + (int nDaysToAdd)
    {
        CDate newDate (m_nDay, m_nMonth, m_nYear);
        newDate.AddDays (nDaysToAdd);

        return newDate;
   }

    void DisplayDate ()
    {
        std::cout << m_nDay << " / " << m_nMonth << " / " << m_nYear;
    }
};

int main ()
{
    // Utworzenie i inicjalizacja obiektu wraz z dat 25-go maja 2008
    CDate mDate (25, 6, 2008);

    std::cout << "Obiekt zostal zainicjalizowany z dat: ";
    
    // Wywietlenie daty pocztkowej
    mDate.DisplayDate ();
   std::cout << std::endl;

   std::cout << "Data po dodaniu dziesieciu dni to: ";

    // Dodanie 10 (dni)...
    CDate datePlus10 (mDate + 10);

   datePlus10.DisplayDate ();

   return 0;
}
