// Demonstruje deklarowanie konstruktora
// i destruktora dla klasy Cat
// Domylny konstruktor zosta stworzony przez programist
#include <iostream>            // dla cout

class Cat                      // pocztek deklaracji klasy
{
    public:                        // pocztek sekcji publicznej
        Cat(int initialAge);       // konstruktor
        ~Cat();                    // destruktor
        int GetAge();              // akcesor
        void SetAge(int age);      // akcesor
        void Meow();
    private:                       // pocztek sekcji prywatnej
        int itsAge;                // zmienna skadowa
};

// konstruktor klasy Cat
Cat::Cat(int initialAge)
{
   itsAge = initialAge;
}

Cat::~Cat()                    // destruktor, nic nie robi
{
}

// GetAge, publiczny akcesor
// zwraca warto skadowej itsAge
int Cat::GetAge()
{
    return itsAge;
}

// definicja SetAge, akcesora
// publicznego
void Cat::SetAge(int age)
{
    // ustawia zmienn skadow itsAge
    // zgodnie z wartoci przekazan w parametrze age
    itsAge = age;
}

// definicja metody Meow
// zwraca: void
// parametery: brak
// dziaanie: wywietla na ekranie sowo "miauczy"
void Cat::Meow()
{
    std::cout << "Miauczy.\n";
}

// tworzy kota, ustawia jego wiek, sprawia,
// e miauczy, wywietla jego wiek i ponownie miauczy.
int main()
{
    Cat Mruczek(5);
    Mruczek.Meow();
    std::cout << "Mruczek jest kotem i ma " ;
    std::cout << Mruczek.GetAge() << " lat.\n";
    Mruczek.Meow();
    Mruczek.SetAge(7);
    std::cout << "Teraz Mruczek ma " ;
    std::cout << Mruczek.GetAge() << " lat.\n";
    return 0;
}
