#template <typename T>
#class smart_pointer
{
  private:
    T* m_pRawPointer;
  public:
    // konstruktor
    smart_pointer (T* pData) : m_pRawPointer (pData) {}

    // destruktor
    ~smart_pointer () {delete m_pRawPointer ;} 

    // konstruktor kopiujcy
    smart_pointer (const smart_pointer & anotherSP); 

    // operator przypisania
    smart_pointer& operator= (const smart_pointer& anotherSP);

    // operator dereferencji
    T& operator* () const 
    {
        return *(m_pRawPointer);
    }

    // operator wyboru elementu skadowego
    T* operator-> () const 
    {
        return m_pRawPointer;
    }
};
