// Listing 11.12 Demonstracja dziedziczenia prywatnego
#include <iostream>
using namespace std;

class ElectricMotor
{
  public:
    ElectricMotor () {};
    virtual ~ElectricMotor () {};

  public:
    void StartMotor ()
    {
        Accelerate ();
        Cruise ();
    }

    void StopMotor ()
    {
        cout << "Silnik zatrzymany" << endl;
    };

  private:
    void Accelerate () 
    {
        cout << "Silnik uruchomiony" << endl;
    }

    void Cruise ()
    {
        cout << "Silnik dziala ze stala predkoscia" << endl;
   }
};

class Fan : private ElectricMotor
{
  public:
    Fan () {};
    ~Fan () {}

    void StartFan ()
    {
        StartMotor ();
    }

    void StopFan ()
    {
       StopMotor ();
    }
};

int main ()
{
   Fan mFan;

    mFan.StartFan ();
    mFan.StopFan (); 

    /*
        Uwaga: dwie kolejne linie uzyskuj dostp do klasy bazowej ElectricMotor
        Jednak, poniewa klasa Fan stosuje 'dziedziczenie prywatne' po klasie ElectricMotor,
        ani egzemplarz klasy bazowej ani jej metody publiczne 
        nie s dostpne dla uytkownikw klasy Fan.
        Usunicie znakw komentarzy spowoduje wygenerowanie bdu podczas kompilacji!
    */
    // mFan.Accelerate ();    
    // ElectricMotor * pMotor = &mFan;

    return 0;
}
