#define DEBUG
#define SHOW_INVARIANTS
#include <iostream>
#include <string.h>
using namespace std;

#ifndef DEBUG
   #define ASSERT(x)
#else
   #define ASSERT(x) \
         if (! (x)) \
         { \
            cout << "BLAD!! Asercja " << #x << " nie jest spelniona." << endl; \
            cout << " W linii " << __LINE__  << endl; \
            cout << " w pliku " << __FILE__ << endl;  \
         }
#endif


const int FALSE = 0;
const int TRUE = 1;
typedef int BOOL;


class String
{
  public:
    // konstruktory
    String();
    String(const char *const);
    String(const String &);
    ~String();
 
    char & operator[](int offset);
    char operator[](int offset) const;

    String & operator= (const String &);
    int GetLen()const { return itsLen; }
    const char * GetString() const { return itsString; }
    BOOL Invariants() const;

  private:
    String (int);         // prywatny konstruktor
    char * itsString;
    // unsigned short itsLen;
    int itsLen;
};

// domylny konstruktor tworzy cig tekstowy o dugoci zera bajtw
String::String()
{
   itsString = new char[1];
   itsString[0] = '\0';
   itsLen=0;
   ASSERT(Invariants());
}

// prywatny (pomocniczy) konstruktor, uywany tylko przez
// metody klasy do tworzenia nowego cigu tekstowego
// o danej dugoci, wypenionego znakami null.
String::String(int len)
{
   itsString = new char[len+1];
   for (int i = 0; i<=len; i++)
      itsString[i] = '\0';
   itsLen=len;
   ASSERT(Invariants());
}

// Konwertuje tablic znakw w obiekt String
String::String(const char * const cString)
{
   itsLen = strlen(cString);
   itsString = new char[itsLen+1];
   for (int i = 0; i<itsLen; i++)
      itsString[i] = cString[i];
   itsString[itsLen]='\0';
   ASSERT(Invariants());
}

// konstruktor kopiujcy
String::String (const String & rhs)
{
   itsLen=rhs.GetLen();
   itsString = new char[itsLen+1];
   for (int i = 0; i<itsLen;i++)
      itsString[i] = rhs[i];
   itsString[itsLen] = '\0';
   ASSERT(Invariants());
}

// destruktor, zwalnia zaalokowan pami
String::~String ()
{
   ASSERT(Invariants());
   delete [] itsString;
   itsLen = 0;
}

// operator przypisania, zwalnia istniejc pami,
// po czym kopiuje cig tekstowy i rozmiar
String& String::operator=(const String & rhs)
{
   ASSERT(Invariants());
   if (this == &rhs)
      return *this;
   delete [] itsString;
   itsLen=rhs.GetLen();
   itsString = new char[itsLen+1];
   for (int i = 0; i<itsLen;i++)
      itsString[i] = rhs[i];
   itsString[itsLen] = '\0';
   ASSERT(Invariants());
   return *this;
}

// nie const operator indeksu
char & String::operator[](int offset)
{
   ASSERT(Invariants());
   if (offset > itsLen)
   {
      ASSERT(Invariants());
      return itsString[itsLen-1];
   }
   else
   {
      ASSERT(Invariants());
      return itsString[offset];
   }
}

// const operator indeksu
char String::operator[](int offset) const
{
   ASSERT(Invariants());
   char retVal;
   if (offset > itsLen)
      retVal = itsString[itsLen-1];
   else
      retVal = itsString[offset];
   ASSERT(Invariants());
   return retVal;
}

BOOL String::Invariants() const
{
   #ifdef SHOW_INVARIANTS
      cout << "String OK ";
   #endif
   return ( (itsLen && itsString) || (!itsLen && !itsString) );
}

class Animal
{
  public:
    Animal():itsAge(1),itsName("John Q. Animal")
       {ASSERT(Invariants());}
    Animal(int, const String&);
    ~Animal(){}
    int GetAge() {  ASSERT(Invariants()); return itsAge;}
    void SetAge(int Age)
    {
       ASSERT(Invariants());
       itsAge = Age;
       ASSERT(Invariants());
    }
    String& GetName()
    {
       ASSERT(Invariants());
       return itsName;
    }
    void SetName(const String& name)
    {
       ASSERT(Invariants());
       itsName = name;
       ASSERT(Invariants());
    }
    BOOL Invariants();
  private:
    int itsAge;
    String itsName;
};

Animal::Animal(int age, const String& name):
   itsAge(age),
   itsName(name)
{
   ASSERT(Invariants());
}

BOOL Animal::Invariants()
{
   #ifdef SHOW_INVARIANTS
      cout << "Animal OK ";
   #endif
      return (itsAge > 0 && itsName.GetLen());
}

int main()
{
   Animal sparky(5,"Sparky");
   cout << endl << sparky.GetName().GetString() << " ma ";
   cout << sparky.GetAge() << " lat.";
   sparky.SetAge(8);
   cout << endl << sparky.GetName().GetString() << " ma ";
   cout << sparky.GetAge() << " lat.";
   return 0;
}
