#include <iostream>
using namespace std;

const int DefaultSize = 10;

class Array
{
  public:
    // konstruktory
    Array(int itsSize = DefaultSize);
    Array(const Array &rhs);
    ~Array() { delete [] pType;}

    // operatory
    Array& operator=(const Array&);
    int& operator[](int offSet);
    const int& operator[](int offSet) const;

    // akcesory
    int GetitsSize() const { return itsSize; }

    // funkcja zaprzyjaniona
    friend ostream& operator<< (ostream&, const Array&);

    // definiujemy klasy wyjtkw
    class xBoundary {};
    class xSize {};
    class xTooBig : public xSize {};
    class xTooSmall : public xSize {};
    class xZero  : public xTooSmall {};
    class xNegative  : public xSize {};
  private:
    int *pType;
    int  itsSize;
};


Array::Array(int size):
   itsSize(size)
{
   if (size == 0)
      throw xZero();
   if (size > 30000)
      throw xTooBig();
   if (size <1)
      throw xNegative();
   if (size < 10)
      throw xTooSmall();

   pType = new int[size];
   for (int i = 0; i<size; i++)
      pType[i] = 0;
}

int& Array::operator[](int offSet)
{
   int size = GetitsSize();
   if (offSet >= 0 && offSet < GetitsSize())
      return pType[offSet];
   throw xBoundary();
   return pType[0];  // ucisza MSC
}

const int& Array::operator[](int offSet) const
{
   int mysize = GetitsSize();
 66:
   if (offSet >= 0 && offSet < GetitsSize())
      return pType[offSet];
   throw xBoundary();

   return pType[0];  // ucisza MSC
}

int main()
{
   try
   {
      Array intArray(0);
      for (int j = 0; j< 100; j++)
      {
         intArray[j] = j;
         cout << "intArray[" << j << "] w porzadku..." << endl;
      }
   }
   catch (Array::xBoundary)
   {
      cout << "Nie moglem przetworzyc tych danych!" << endl;
   }
   catch (Array::xTooBig)
   {
      cout << "Ta tablica jest zbyt duza..." << endl;
   }

   catch (Array::xTooSmall)
   {
      cout << "Ta tablica jest zbyt mala..." << endl;
   }
   catch (Array::xZero)
   {
      cout << "Poprosiles o tablice";
      cout << " zawierajaca zero obiektow!" << endl;
   }
   catch (...)
   {
      cout << "Cos poszlo nie tak!" << endl;
   }
   cout << "Gotowe." << endl;
   return 0;
}
