#include <algorithm>
#include <string>
#include <vector>
#include <deque>
#include <iostream>
#include <functional>

int main ()
{
    using namespace std;

    string strSample ("TO jest TEstowy ciag tektowy!");
    cout << "Przykladowy ciag tekstowy to: " << strSample << endl;

    string strLowerCaseCopy;
    strLowerCaseCopy.resize (strSample.size ());
    
    transform ( strSample.begin ()          // pocztek zakresu rdowego
              , strSample.end ()          // koniec zakresu rdowego
              , strLowerCaseCopy.begin ()// pocztek zakresu docelowego
              , tolower );        // funkcja jednoargumentowa 

    cout << "Wynik uzycia algorytmu 'transform' wraz z funkcja 'tolower' wzgledem ciagu tekstowego:" << endl;
    cout << "\"" << strLowerCaseCopy << "\"" << endl << endl;

    // Dwa przykadowe obiekty vector przechowujce liczby cakowite...
    vector <int> vecIntegers1, vecIntegers2;
    for (int nNum = 0; nNum < 10; ++ nNum) 
    {
        vecIntegers1.push_back (nNum);
        vecIntegers2.push_back (10 - nNum);
    }

    // Zakres docelowy przeznaczony do przechowywania wyniku dodawania 
    deque <int> dqResultAddition (vecIntegers1.size ());

    transform ( vecIntegers1.begin ()    // pocztek pierwszego zakresu rdowego
              , vecIntegers1.end ()      // koniec pierwszego zakresu rdowego
              , vecIntegers2.begin ()    // pocztek drugiego zakresu rdowego
              , dqResultAddition.begin ()// koniec drugiego zakresu rdowego
              , plus <int> () );          // funkcja dwuargumentowa

    cout << "Wynik uzycia algorytmu 'transform' wraz z funkcja dwuargumentowa 'plus': " << endl;
    cout <<endl << "Indeks   Vector1 + Vector2 = Wynik (w Deque)" << endl;
    for (size_t nIndex = 0; nIndex < vecIntegers1.size (); ++ nIndex)
    {
        cout << nIndex << "    \t " << vecIntegers1 [nIndex]  << "\t+   ";
        cout << vecIntegers2 [nIndex]  << " \t  =    ";
        
        cout << dqResultAddition [nIndex] << endl;
    }

    return 0;
}
