#include <algorithm>
#include <vector>
#include <list>
#include <iostream>

int main ()
{
    using namespace std;

    // Przykadowy kontener - obiekt vector przechowujcy liczby cakowite
    vector <int> vecIntegers;

    for (int nNum = -9; nNum < 10; ++ nNum)
        vecIntegers.push_back (nNum);

    // Wstawienie przykadowych wartoci do obiektu vector
    vecIntegers.push_back (9);
    vecIntegers.push_back (9);

    // Inny przykadowy kontener - obiekt list przechowujcy liczby cakowite
    list <int> listIntegers;

    for (int nNum = -4; nNum < 5; ++ nNum)
        listIntegers.push_back (nNum);

    // Wywietlenie zawartoci kolekcji...
    cout << "Zawartosc przykladowego obiektu vector to: " << endl;
    vector <int>::const_iterator iVecElementLocator;
    for ( iVecElementLocator = vecIntegers.begin ()
        ; iVecElementLocator != vecIntegers.end ()
        ; ++ iVecElementLocator )
        cout << *iVecElementLocator << ' ';

    cout << endl << "Zawartosc przykladowego obiektu list to: " << endl;
    list <int>::const_iterator ilistElementLocator;
    for ( ilistElementLocator = listIntegers.begin ()
        ; ilistElementLocator != listIntegers.end ()
        ; ++ ilistElementLocator )
        cout << *ilistElementLocator << ' '; 

    cout << endl << endl;
    cout << "Wyszukanie zawartosci obiektu 'list' w obiekcie 'vector' za pomoca algorytmu 'search': " << endl;

    // Przeszukanie obiektu vector pod ktem elementw obiektu list
    vector <int>::iterator iRangeLocated;
    iRangeLocated = search ( vecIntegers.begin () // Pocztek zakresu
                  , vecIntegers.end ()      // Koniec przeszukiwanego zakresu
                  , listIntegers.begin ()  // Pocztek szukanego zakresu
                  , listIntegers.end () ); // Koniec szukanego zakresu

    // Sprawdzenie, czy znaleziono dopasowanie
    if (iRangeLocated != vecIntegers.end ())
    {
        cout << "Sekwencja obiektu list zostala dopasowana w obiekcie vector ";
        cout << "w polozeniu: ";
        cout << distance (vecIntegers.begin (), iRangeLocated);

        cout << endl << endl;
    }

    cout << "Wyszukiwanie elementow {9, 9, 9} w obiekcie vector za pomoca algorytmu 'search_n': ";
    cout << endl;

    // Teraz obiekt vector jest przeszukiwany pod ktem wystpowania wzorca {9, 9, 9}
    vector <int>::iterator iPartialRangeLocated;
    iPartialRangeLocated = search_n ( vecIntegers.begin () // Pocztek zakresu
                           , vecIntegers.end ()   // Koniec zakresu
                           , 3        // Liczba szukanych elementw
                           , 9 );    // Element do wyszukania

    if (iPartialRangeLocated != vecIntegers.end ())
    {
        cout << "Sekwencja {9, 9, 9} zostala dopasowana w obiekcie vector ";
        cout << "w polozeniu: ";
        cout << distance (vecIntegers.begin (), iPartialRangeLocated);
        
        cout << endl;
    }
    
    return 0;
}
