#include <vector>
#include <iostream>
#include <algorithm>

template <typename elementType>
class CMultiply
{
  public:
    elementType operator () (const elementType& elem1, 
        const elementType& elem2)
    {
        return (elem1 * elem2); 
    }
};

int main ()
{
    using namespace std;

    // Utworzenie dwch przykadowych obiektw vector, z ktrych kady przechowuje po dziesi liczb cakowitych
    vector <int> vecMultiplicand, vecMultiplier;

    // Wstawienie wartoci przykadowych od 0 do 9
    for (int nCount1 = 0; nCount1 < 10; ++ nCount1)
        vecMultiplicand.push_back (nCount1);

    // Wstawienie wartoci przykadowych od 100 do 109
    for (int nCount2 = 100; nCount2 < 110; ++ nCount2)
        vecMultiplier.push_back (nCount2);

    // Trzeci kontener bdzie przechowywa wyniki operacji mnoenia 
    vector <int> vecResult;

    // Zrobienie miejsca dla wynikw operacji mnoenia
    vecResult.resize (10);

    transform (    vecMultiplicand.begin (), // zakres mnoenia 
                vecMultiplicand.end (), // koniec zakresu
                vecMultiplier.begin (),  // wartoci mnonika
                vecResult.begin (), // zakres przechowujcy wyniki
                CMultiply <int> () );    // funkcja przeprowadzajca mnoenie

    cout << "Zawartosc pierwszego obiektu vector: " << endl;
    for (size_t nIndex1 = 0; nIndex1 < vecMultiplicand.size (); ++ nIndex1)
        cout << vecMultiplicand [nIndex1] << ' ';
    cout << endl;

    cout << "Zawartosc drugiego obiektu vector: " << endl;
    for (size_t nIndex2 = 0; nIndex2 < vecMultiplier.size (); ++nIndex2)
        cout << vecMultiplier [nIndex2] << ' ';
    cout << endl << endl;

    cout << "Wyniki operacji mnozenia: " << endl;
    for (size_t nIndex = 0; nIndex < vecResult.size (); ++ nIndex)
        cout << vecResult [nIndex] << ' '; 

    return 0;
}
