#include <algorithm>
#include <iostream>
#include <vector>
#include <list>

using namespace std;

template <typename elementType>
struct DisplayElementKeepCount
{
    // Przechowywanie wartoci licznika w zmiennej skadowej
    int m_nCount;

    // Konstruktor
    DisplayElementKeepCount ()
    {
        m_nCount = 0;
    }

    // Wywietlenie elementu, uaktualnienie wartoci licznika!
    void operator () (const elementType& element)
    {
        ++ m_nCount;
        cout << element << ' ';
    }
};

int main ()
{
    vector <int> vecIntegers;

    for (int nCount = 0; nCount < 10; ++ nCount)
        vecIntegers.push_back (nCount);

    cout << " Wyswietlanie obiektu vector przechowujacego liczby calkowite: " << endl; 

    // Display the array of integers
    DisplayElementKeepCount <int> mResult;
    mResult = for_each ( vecIntegers.begin ()   // Pocztek zakresu
                    , vecIntegers.end ()        // Koniec zakresu
                    , DisplayElementKeepCount <int> () );// Obiekt funkcji

    cout << endl << endl;

    // Uycie w wartoci zwracanej dla kadego for_each przechowywanej informacji o stanie!
    cout << "Wyswietlono '" << mResult.m_nCount << "' elementow!" << endl;

    return 0;
}
