#include <list>
#include <string>
#include <iostream>

using namespace std;

enum MenuOptionSelection
{
    InsertContactListEntry = 0,
    SortOnName = 1,
    SortOnNumber = 2,
    DisplayEntries = 3,
    EraseEntry = 4,
    QuitContactList = 5
};

struct ContactListItem
{
    string strContactsName;
    string strPhoneNumber; 

    // Konstruktor i destruktor
    ContactListItem (const string& strName, const string & strNumber)
    {
        strContactsName = strName;
        strPhoneNumber = strNumber;
    }

    bool operator == (const ContactListItem& itemToCompare) const
    {
        return (itemToCompare.strContactsName == this->strContactsName);
    }

    bool operator < (const ContactListItem& itemToCompare) const
    {
        return (this->strContactsName < itemToCompare.strContactsName);
    }
};


int ShowMenu ();
ContactListItem GetContactInfo ();
void DisplayContactList (const list <ContactListItem>& listContacts);
void EraseEntryFromList (list <ContactListItem>& listContacts);
bool Predicate_CheckItemsOnNumber (const ContactListItem& item1, 
                                   const ContactListItem& item2);

int main ()
{
    list <ContactListItem> listContacts;
    int nUserSelection = 0;

    while ((nUserSelection = ShowMenu ()) != (int) QuitContactList)
    {
        switch (nUserSelection)
        {
        case InsertContactListEntry:
            listContacts.push_back (GetContactInfo ());
            cout << "Lista kontaktow zostala uaktualniona!" << endl << endl;
            break;

        case SortOnName:
            listContacts.sort ();
            DisplayContactList (listContacts);
            break;

        case SortOnNumber:
            listContacts.sort (Predicate_CheckItemsOnNumber);
            DisplayContactList (listContacts);
            break;

        case DisplayEntries:
            DisplayContactList (listContacts);
            break;

        case EraseEntry:
            EraseEntryFromList (listContacts);
            DisplayContactList (listContacts);
            break;

        case QuitContactList:
            cout << "Zakonczenie pracy aplikacji, zegnaj!" << endl;
            break;

        default:
            cout << "Nieprawidlowe dane wejsciowe '" << nUserSelection << ".'";
            cout << "Wybierz opcje z zakresu od 0 do 4" << endl << endl;
            break;
        }
    }

    cout << "Koniec! Zegnaj!" << endl;

    return 0;
}

int ShowMenu ()
{
     cout << "*** Co chcialbys teraz zrobic? ***" << endl << endl;
    cout << "Wybierz 0, aby podac imie i numer telefonu" << endl;
    cout << "Wybierz 1, aby posortowac liste wzgledem imienia" << endl;
    cout << "Wybierz 2, aby posortowac liste wzgledem numeru" << endl;
    cout << "Wybierz 3, aby wyswietlic wszystkie wpisy" << endl;
    cout << "Wybierz 4, aby usunac wpis" << endl;
    cout << "Wybierz 5, aby zakonczyc prace aplikacji" << endl << endl;
    cout << "> ";

    int nOptionSelected = 0; 

    // Akceptacja danych wejciowych uytkownika
    cin >> nOptionSelected ;

    cout << endl;
    return nOptionSelected;
}

bool Predicate_CheckItemsOnNumber (const ContactListItem& item1, 
                                   const ContactListItem& item2)
{
    return (item1.strPhoneNumber < item2.strPhoneNumber);
}

ContactListItem GetContactInfo ()
{
    cout << "*** Podaj informacje kontaktowe ***" << endl;
    string strName;
    cout << "Prosze podac imie osoby" << endl;;
    cout << "> ";
    cin >> strName;

    string strPhoneNumber;
    cout << "Prosze podac numer telefonu" << strName "'a" << endl;
    cout << "> ";
    cin >> strPhoneNumber;

    return ContactListItem (strName, strPhoneNumber);
}

void DisplayContactList (const list <ContactListItem>& listContacts)
{
    cout << "*** Wyswietlanie informacji kontaktowych ***" << endl;
    cout << "Na liscie kontaktow znajduja sie" << listContacts.size ();
    cout << " wpisy" << endl;

    list <ContactListItem>::const_iterator iContact;
    for ( iContact = listContacts.begin ()
        ; iContact != listContacts.end ()
        ; ++ iContact )
    {
        cout << "Imie: '" << iContact->strContactsName;
        cout << "' Numer: '" << iContact->strPhoneNumber << "'" << endl;
    }

    cout << endl;
}

void EraseEntryFromList (list <ContactListItem>& listContacts)
{
    cout << "*** Usuniecie wpisu ***" << endl;
    cout << "Podaj imie osoby, ktora chcesz usunac z listy" << endl;
    cout << "> ";
    string strNameToErase;
    cin >> strNameToErase;

    listContacts.remove (ContactListItem (strNameToErase, ""));
}
