#include <list>
#include <iostream>

using namespace std;

void PrintListContents (const list <int>& listInput);

int main ()
{
    std::list <int> listIntegers;

    // Wstawianie elementw na pocztku...
    listIntegers.push_front (4);
    listIntegers.push_front (3);
    listIntegers.push_front (2);

    listIntegers.push_front (1);
    listIntegers.push_front (0);

    // Wstawianie elementu na kocu...
    listIntegers.push_back (5);

    cout << "Poczatkowa zawartosc obiektu list:" << endl;
    PrintListContents (listIntegers);

    listIntegers.reverse ();

    cout << "Zawartosc obiekt list po uzyciu funkcji reverse():" << endl;
    PrintListContents (listIntegers);

    return 0; 
}

void PrintListContents (const list <int>& listInput)
{
    if (listInput.size () > 0)
    {
        // Wywietlenie wartoci na ekranie...
        cout << "{ ";

        std::list <int>::const_iterator iElementLocator;
        for ( iElementLocator = listInput.begin ()
            ; iElementLocator != listInput.end ()
            ; ++ iElementLocator )
            cout << *iElementLocator << " ";

        cout << "}" << endl << endl;
    }
    else
        cout << "Obiekt list jest pusty!" << endl;
}
