#include <iostream>

class CDate
{
  private:
    int m_nDay;    // Zakres: 1 - 30 (zakadamy, e miesice maj po 30 dni!)
    int m_nMonth;    // Zakres: 1 - 12
    int m_nYear;

   void AddDays (int nDaysToAdd);
   void AddMonths (int nMonthsToAdd);
    void AddYears (int m_nYearsToAdd);

  public:

    // Konstruktor inicjalizujcy obiekt dla dnia, miesica i roku
    CDate (int nDay, int nMonth, int nYear)
          : m_nDay (nDay), m_nMonth (nMonth), m_nYear (nYear) {};

    void DisplayDate ()
   {
        cout << m_nDay << " / " << m_nMonth << " / " << m_nYear;
   }

   bool operator < (const CDate& mDateObj) const;
   bool operator <= (const CDate& mDateObj) const;

   bool operator > (const CDate& mDateObj) const;
   bool operator >= (const CDate& mDateObj) const; 
};

CDate::operator int() const
{
    return ((m_nYear * 10000) + (m_nMonth * 100) + m_nDay); 
}

bool CDate::operator < (const CDate& mDateObj) const
{
    return (this->operator int () < mDateObj.operator int ());
}

bool CDate::operator > (const CDate& mDateObj) const
{
    return (this->operator int () > mDateObj.operator int ());
}

bool CDate::operator <= (const CDate& mDateObj) const
{
    return (this->operator int () <= mDateObj.operator int ());
}

bool CDate::operator >= (const CDate& mDateObj) const
{
    return (this->operator int () >= mDateObj.operator int ());
}

// Definicje innych funkcji pobierz z listingu 13.8

int main ()
{
    // Utworzenie i inicjalizacja obiektu wraz z dat 25-go maja 2008
    CDate mDate1 (25, 6, 2008);
    CDate mDate2 (23, 5, 2009);
    CDate mDate3 (23, 5, 2009);

    cout << "mDate1 zawiera: ";
    mDate1.DisplayDate ();
    cout << endl;

    cout << "mDate2 zawiera: ";
    mDate2.DisplayDate ();
    cout << endl;

    cout << "mDate3 zawiera: ";
    mDate3.DisplayDate ();
    cout << endl;

    // Uycie operatora <
    cout << "mDate3 < mDate2: ";
    cout << ((mDate3 < mDate2) ? "true" : "false") << endl;

    // Uycie operatora <=
    cout << "mDate3 <= mDate2: ";
    cout << ((mDate3 <= mDate2) ? "true" : "false") << endl;

    // Uycie operatora >=
    cout << "mDate3 >= mDate1: ";
    cout << ((mDate3 >= mDate1) ? "true" : "false") << endl;

    // Uycie operatora >
    cout << "mDate1 > mDate3: ";
    cout << ((mDate1 > mDate3) ? "true" : "false") << endl; 

    return 0;
}
