#include <iostream>
using namespace std; 
class CDate
{
  private:
    int m_nDay;    // Zakres: 1 - 30 (zakadamy, e miesice maj po 30 dni!)
    int m_nMonth;    // Zakres: 1 - 12
    int m_nYear;

   void AddDays (int nDaysToAdd);
   void AddMonths (int nMonthsToAdd);
    void AddYears (int m_nYearsToAdd);

  public:

    // Konstruktor inicjalizujcy obiekt dla dnia, miesica i roku
    CDate (int nDay, int nMonth, int nYear)
          : m_nDay (nDay), m_nMonth (nMonth), m_nYear (nYear) {};

    void DisplayDate ()
    {
        cout << m_nDay << " / " << m_nMonth << " / " << m_nYear;
    }

    // operator konwersji na posta liczby cakowitej
   operator int();

   // operator rwnoci, ktry pomaga w przypadku polece takich jak: if (mDate1 == mDate2)...
   bool operator == (const CDate& mDateObj);

    // przeciony operator rwnoci, ktry pomaga w przypadku polece takich jak: if (mDate == nInteger)
   bool operator == (int nDateNumber);

    // operator nierwnoci
    bool operator != (const CDate& mDateObj);

    // przeciony operator nierwnoci dla typw w postaci liczb cakowitych
   bool operator != (int nDateNumber);
};

CDate::operator int()
{
   return ((m_nYear * 10000) + (m_nMonth * 100) + m_nDay);
}

// operator rwnoci, ktry pomaga w przypadku polece takich jak: if (mDate1 == mDate2)...
bool CDate::operator == (const CDate& mDateObj)
{
    return ( (mDateObj.m_nYear == m_nYear)
            && (mDateObj.m_nMonth == m_nMonth)
           && (mDateObj.m_nDay == m_nDay) );
}

bool CDate::operator == (int nDateNumber)
{
    return nDateNumber == (int)*this;
}

// operator nierwnoci
bool CDate::operator != (const CDate& mDateObj)
{
    return !(this->operator== (mDateObj));
}

bool CDate::operator != (int nDateNumber)
{
    return !(this->operator == (nDateNumber));
}

void CDate::AddDays (int nDaysToAdd) 
{
    m_nDay += nDaysToAdd;

   if (m_nDay > 30)
   {
       AddMonths (m_nDay / 30);

       m_nDay %= 30;    // po przekroczeniu 30-go -> 1-szy
   }
}
void CDate::AddMonths (int nMonthsToAdd)
{
   m_nMonth += nMonthsToAdd;

   if (m_nMonth > 12)
   {
       AddYears (m_nMonth / 12);

       m_nMonth %= 12;    // po przekroczeniu grudnia -> stycze
   }
}
void CDate::AddYears (int m_nYearsToAdd) 
{
   m_nYear += m_nYearsToAdd;
}

int main ()
{
   // Utworzenie i inicjalizacja obiektu wraz z dat 25-go maja 2008
   CDate mDate1 (25, 6, 2008);

   cout << "mDate1 zawiera: ";
   
   // Wywietlenie daty pocztkowej
   mDate1.DisplayDate ();
   cout << endl;

   CDate mDate2 (23, 5, 2009);
   cout << "mDate2 zawiera: ";
   mDate2.DisplayDate ();
   cout << endl;

   // Uycie operatora nierwnoci
   if (mDate2 != mDate1)
       cout << "Zgodnie z oczekiwaniami, te dwie daty nie sa rowne!" << endl;

   CDate mDate3 (23, 5, 2009);
   cout << "mDate3 zawiera: ";
   mDate3.DisplayDate ();
   cout << endl;

   // Uycie operatora nierwnoci
   if (mDate3 == mDate2)
       cout << "mDate3 i mDate2 sa rowne" << endl;

   // Pobranie liczby cakowitej bdcej odpowiednikiem daty mDate3 uywajc w tym celu operatora int()
   int nIntegerDate3 = mDate3;

   cout<< "Liczba calkowita bedaca odpowiednikiem daty to mDate3 to: "<< nIntegerDate3<< endl;
   
   // Uycie przecionego operatora == (w celu porwnania z liczb cakowit)
   if (mDate3 == nIntegerDate3)
       cout << "Liczba calkowita i mDate3 pasuja do siebie" << endl;

   // Uycie przecionego operatora != akceptujcego liczby cakowite
   if (mDate1 != nIntegerDate3)
       cout << "mDate1 nie jest rowne mDate3";

   return 0;
}
