// Listing 9.10 - Przekazywanie wskanikw do obiektw

#include <iostream>

using namespace std;
class SimpleCat
{
    public:
        SimpleCat();
        SimpleCat(SimpleCat&);
        ~SimpleCat();

        int GetAge() const { return itsAge; }
        void SetAge(int age) { itsAge = age; }

    private:
        int itsAge;
};

SimpleCat::SimpleCat()
{
    cout << "Konstruktor klasy SimpleCat..." << endl;
    itsAge = 1;
}

SimpleCat::SimpleCat(SimpleCat&)
{
    cout << "Konstruktor kopiujcy klasy SimpleCat..." << endl;
}

SimpleCat::~SimpleCat()
{
    cout << "Destruktor klasy SimpleCat..." << endl;
}

const SimpleCat * const FunctionTwo 
    (const SimpleCat * const theCat);

int main()
{
    cout << "Tworze obiekt..." << endl;
    SimpleCat Mruczek;
    cout << "Mruczek ma " ;
    cout << Mruczek.GetAge();
    cout << " lat" << endl;
    int age = 5;
    Mruczek.SetAge(age);
    cout << "Mruczek ma " ;
    cout << Mruczek.GetAge();
    cout << " lat" << endl;
    cout << "Wywoluje funkcje FunctionTwo..." << endl;
    FunctionTwo(&Mruczek);
    cout << "Mruczek ma " ;
    cout << Mruczek.GetAge();
    cout << " lat" << endl;
    return 0;
}

// functionTwo, otrzymuje wskanik const
const SimpleCat * const FunctionTwo 
    (const SimpleCat * const theCat)
{
    cout << "FunctionTwo. Wracam..." << endl;
    cout << "Mruczek ma teraz " << theCat->GetAge();
    cout << " lat " << endl;
    // theCat->SetAge(8);   const!
    return theCat;
}
