#include <algorithm>
#include <vector>
#include <iostream>

// Predykat jednoargumentowy dla funkcji *_if
template <typename elementType>
bool IsEven (const elementType& number)
{
    // Zwraca warto true, jeeli liczba jest parzysta
    return ((number % 2) == 0);
}

int main ()
{
    using namespace std;

    // Przykadowy kontener - obiekt vector przechowujcy liczby cakowite
    vector <int> vecIntegers;

    // Wstawienie przykadowych wartoci
    for (int nNum = -9; nNum < 10; ++ nNum) 
        vecIntegers.push_back (nNum);

    // Wywietlenie wszystkich elementw kolekcji
    cout << "Elementy w przykladowej kolekcji to: " << endl;
    vector <int>::const_iterator iElementLocator;
    for ( iElementLocator = vecIntegers.begin ()
        ; iElementLocator != vecIntegers.end ()
        ; ++ iElementLocator )
        cout << *iElementLocator << ' ';

    cout << endl << endl;

    // Obliczenie cakowitej liczby elementw
    cout << "Kolekcja zawiera '";
    cout << vecIntegers.size () << "' elementow" << endl;

    // Uycie algorytmu count_if wraz z predykatem jednoargumentowym IsEven:
    size_t nNumEvenElements = count_if (vecIntegers.begin (), 
                                vecIntegers.end (), IsEven <int> );

    cout << "Liczba elementow parzystych: " << nNumEvenElements << endl;
    cout << "Liczba elementow nieparzystych: ";
    cout << vecIntegers.size () - nNumEvenElements << endl;

    // Uycie algorytmu count w celu obliczenia liczby wystpie elementu '0' w obiekcie vector
    size_t nNumZeroes = count (vecIntegers.begin (),vecIntegers.end (),0);
    cout << "Liczba wystapien elementu '0': " << nNumZeroes << endl << endl;

    cout << "Wyszukanie elementu o wartosci 3 za pomoca algorytmu find: " << endl;

    // Wyszukanie w obiekcie vector liczby cakowitej '3' za pomoc algorytmu 'find'
    vector <int>::iterator iElementFound;
    iElementFound = find ( vecIntegers.begin ()    // Pocztek zakresu
                         , vecIntegers.end ()    // Koniec zakresu
                         , 3 );             // Szukany element

    // Sprawdzenie, czy wyszukanie zakoczyo si powodzeniem
    if ( iElementFound != vecIntegers.end ())
        cout << "Wynik: Element zostal znaleziony!" << endl << endl;
    else
        cout << "Wynik: Element nie zostal znaleziony w kolekcji." << endl;

    cout << "Znajdywanie pierwszej liczby parzystej za pomoca algorytmu find_if: " << endl;

    // Znajdywanie pierwszej liczby parzystej w kolekcji
    vector <int>::iterator iEvenNumber;
    iEvenNumber = find_if ( vecIntegers.begin ()// Pocztek zakresu
                          , vecIntegers.end ()  // Koniec zakresu
                          , IsEven <int> );     // Predykat jednoargumentowy 

    if (iEvenNumber != vecIntegers.end ())
    {
        cout << "Liczba '" << *iEvenNumber << "' zostala znaleziona w polozeniu [";
        cout << distance (vecIntegers.begin (), iEvenNumber);
        cout << "]" << endl;
       }

    return 0;
}
