#include <map>
#include <iostream>
#include <string>

using namespace std;

// Zdefiniowanie typedef dla definicji obiektu  multimap w celu zwikszenia czytelnoci
typedef multimap <int, string> MULTIMAP_INT_STRING;

int main ()
{
    MULTIMAP_INT_STRING mmapIntToString;

    // Wstawienie par kluczwarto do obiektu multimap
    mmapIntToString.insert (MULTIMAP_INT_STRING::value_type (3, "Trzy"));
    mmapIntToString.insert (MULTIMAP_INT_STRING::value_type(45, " Czterdziesci piec"));
    mmapIntToString.insert (MULTIMAP_INT_STRING::value_type (-1, "Minus Jeden"));
    mmapIntToString.insert (MULTIMAP_INT_STRING::value_type (1000, "Tysiac"));

    // Wstawienie duplikatw do obiektu multimap
    mmapIntToString.insert (MULTIMAP_INT_STRING::value_type (-1, "Minus Jeden"));
    mmapIntToString.insert (MULTIMAP_INT_STRING::value_type (1000,"Tysiac"));

    cout << "Obiekt multimap zawiera " << mmapIntToString.size ();
    cout << " par(y) klucz-wartosc. " << "Pary to: " << endl;

    // Wywietlenie na ekranie zawartoci obiektu multimap
    MULTIMAP_INT_STRING::const_iterator iPairLocator;

    for ( iPairLocator = mmapIntToString.begin ()
        ; iPairLocator != mmapIntToString.end ()
        ; ++ iPairLocator )
    {
        cout << "Klucz: " << iPairLocator->first;
        cout << ", Wartosc: " << iPairLocator->second.c_str () << endl;
    }

    cout << endl;

    // Usunicie z obiektu multimap elementu z kluczem -1
    if (mmapIntToString.erase (-1) > 0)
        cout << "Usuniecie wszystkich par z kluczem -1." << endl;

    // Usunicie z obiektu multimap elementu, do ktrego prowadzi podany iterator 
    MULTIMAP_INT_STRING::iterator iElementLocator = mmapIntToString.find(45);
    if (iElementLocator != mmapIntToString.end ())
    {
        mmapIntToString.erase (iElementLocator);
        cout << "Usuniecie par z kluczem 45 za pomoca iteratora" << endl;
    }

    // Usunicie z obiektu multimap zakresu elementw...
    cout << "Usuniecie zakresu par z kluczem 1000." << endl;
    mmapIntToString.erase ( mmapIntToString.lower_bound (1000)
        , mmapIntToString.upper_bound (1000) );

    cout << endl;
    cout << "Obiekt multimap zawiera teraz " << mmapIntToString.size ();
    cout << " par(y) klucz-wartosc." << "Pary to: " << endl;

    // Wywietlenie na ekranie zawartoci obiektu multimap
    for ( iPairLocator = mmapIntToString.begin ()
        ; iPairLocator != mmapIntToString.end ()
        ; ++ iPairLocator )
    {
        cout << "Klucz: " << iPairLocator->first;
        cout << ", Wartosc: " << iPairLocator->second.c_str () << endl;
    }

    return 0;
}
