#include <map>
#include <iostream>

using namespace std;

// Zdefiniowanie typedef dla definicji obiektw map i multimap w celu zwikszenia czytelnoci
typedef map <int, string> MAP_INT_STRING;
typedef multimap <int, string> MMAP_INT_STRING;

int main ()
{
    MAP_INT_STRING mapIntToString;

    // Wstawienie pary kluczwarto do obiektu map za pomoc  value_type
    mapIntToString.insert (MAP_INT_STRING::value_type (3, "Trzy"));

    // Wstawienie pary uywajc funkcji make_pair
    mapIntToString.insert (make_pair (-1, "Minus Jeden"));

    // Bezporednie wstawienie obiektu pary
    mapIntToString.insert (pair <int, string> (1000, "Tysiac"));

    // Wstawienie pary kluczwarto uywajc skadni podobnej do tablicy
    mapIntToString [1000000] = "Milion";

    cout << "Obiekt map zawiera " << mapIntToString.size ();
    cout << " par(y) klucz-wartosc. " << endl;
    cout << "Elementy w obiekcie map to: " << endl;

    // Wywietlenie na ekranie zawartoci obiektu map
    MAP_INT_STRING::const_iterator iMapPairLocator;

    for ( iMapPairLocator = mapIntToString.begin ()
        ; iMapPairLocator != mapIntToString.end ()
        ; ++ iMapPairLocator )
    {
        cout << "Klucz: " << iMapPairLocator->first;
        cout << " Wartosc: " << iMapPairLocator->second.c_str ();
        
        cout << endl;
    }

    MMAP_INT_STRING mmapIntToString;

    // W obiekcie multimap funkcja insert() dziaa dokadnie w taki sam sposb
    mmapIntToString.insert (MMAP_INT_STRING::value_type (3, "Trzy"));
    mmapIntToString.insert (MMAP_INT_STRING::value_type (45, "Czterdziesci piec"));
    mmapIntToString.insert (make_pair (-1, "Minus Jeden"));
    mmapIntToString.insert (pair <int, string> (1000, "Tysiac"));

    // Obiekt multimap moe przechowywa duplikaty  wstawiamy jeden
    mmapIntToString.insert (MMAP_INT_STRING::value_type (1000, "Tysiac"));

    cout << endl << "Obiekt multimap zawiera " << mmapIntToString.size ();
    cout << " par(y) klucz wartosc." << endl;
    cout << "Elementy w obiekcie multimap to: " << endl;

    // Wywietlenie na ekranie zawartoci obiektu multimap
    MMAP_INT_STRING::const_iterator iMultiMapPairLocator;

    for ( iMultiMapPairLocator = mmapIntToString.begin ()
        ; iMultiMapPairLocator != mmapIntToString.end ()
        ; ++ iMultiMapPairLocator )
    {
        cout << "Klucz: " << iMultiMapPairLocator->first;
        cout << ", Wartosc: " << iMultiMapPairLocator->second.c_str ();
        
        cout << endl;
    }

    cout << endl;

    // Obiekt multimap moe rwnie poda liczb par o tym samym kluczu
    cout << "Liczba par w obiektcie multimap wraz z kluczem 1000: "
        << mmapIntToString.count (1000) << endl;

    return 0;
}
