// Listing 12.6
// Dziedziczenie wirtualne
#include <iostream>
using namespace std;

typedef int HANDS;
enum COLOR { Red, Green, Blue, Yellow, White, Black, Brown } ;

class Animal        // wsplna klasa dla klasy Bird i Horse
{
  public:
    Animal(int);
    virtual ~Animal() { cout << "Destruktor klasy Animal...\n"; }
    virtual int GetAge() const { return itsAge; }
    virtual void SetAge(int age) { itsAge = age; }
  private:
    int itsAge;
};

Animal::Animal(int age):
itsAge(age)
{
   cout << "Konstruktor klasy Animal...\n";
}

class Horse : virtual public Animal
{
  public:
    Horse(COLOR color, HANDS height, int age);
    virtual ~Horse() { cout << "Destruktor klasy Horse...\n"; }
    virtual void Whinny()const { cout << "Ihaaa!... "; }
    virtual HANDS GetHeight() const { return itsHeight; }
    virtual COLOR GetColor() const { return itsColor; }
  protected:
    HANDS itsHeight;
    COLOR itsColor;
};

Horse::Horse(COLOR color, HANDS height, int age):
Animal(age),
itsColor(color),itsHeight(height)
{
   cout << "Konstruktor klasy Horse...\n";
}

class Bird : virtual public Animal
{
  public:
    Bird(COLOR color, bool migrates, int age);
    virtual ~Bird() {cout << "Destruktor klasy Bird...\n";  }
    virtual void Chirp()const { cout << "Cwir, cwir... ";  }
    virtual void Fly()const
            { cout << "Moge latac! Moge latac! Moge latac! "; }
    virtual COLOR GetColor()const { return itsColor; }
    virtual bool GetMigration() const { return itsMigration; }
  protected:
    COLOR itsColor;
    bool itsMigration;
};

Bird::Bird(COLOR color, bool migrates, int age):
Animal(age),
itsColor(color), itsMigration(migrates)
{
   cout << "Konstruktor klasy Bird...\n";
}

class Pegasus : public Horse, public Bird
{
  public:
    void Chirp()const { Whinny(); }
    Pegasus(COLOR, HANDS, bool, long, int);
    virtual ~Pegasus() {cout << "Destruktor klasy Pegasus...\n";}
    virtual long GetNumberBelievers() const
         { return  itsNumberBelievers; }
    virtual COLOR GetColor()const { return Horse::itsColor; }
  private:
    long itsNumberBelievers;
};

Pegasus::Pegasus(
   COLOR aColor,
   HANDS height,
   bool migrates,
   long NumBelieve,
   int age):
   Horse(aColor, height,age),
   Bird(aColor, migrates,age),
   Animal(age*2),
   itsNumberBelievers(NumBelieve)
{
   cout << "Konstruktor klasy Pegasus...\n";
}

int main()
{
   Pegasus *pPeg = new Pegasus(Red, 5, true, 10, 2);
   int age = pPeg->GetAge();
   cout << "Ten pegaz ma " << age << " lat.\n";
   delete pPeg;
   return 0;
}
