// KopiujPlik — wykonaj kopie zapasowe plików
//           przekazanych do programu
#include <cstdio>
#include <cstdlib>
#include <fstream>
#include <iostream>
using namespace std;
int main(int nLiczbaArguemntow, char* pszArgs[])
{
    // powtórz proces dla każdego przekazanego pliku
    for (int n = 1; n < nLiczbaArguemntow; n++)
    {
        // utwórz nazwę pliku i nazwę z przyrostkiem .zapas
        string szZrodlo(pszArgs[n]);
        string szCel = szZrodlo + ".zapas";
        // teraz otwórz źródło dla odczytu
        // i cel do zapisu
        ifstream input(szZrodlo.c_str(),
        ios_base::in|ios_base::binary);
        ofstream output(szCel.c_str(),
        ios_base::out|ios_base::binary|ios_base::trunc);
        if (input.good() && output.good())
        {
            cout << "Tworzenie kopii zapasowej " << szZrodlo << "...";
            // czytaj i zapisuj bloki o wieklości 4k (4 kilobajty),
            // aż wystąpi błąd lub dotrzesz do końca pliku
            while(!input.eof() && input.good())
            {
                char bufor[4096];
                input.read(bufor, 4096);
                output.write(bufor, input.gcount());
            }
            cout << "skończone" << endl;
        }
        else
        {
            cerr << "Nie można skopiować " << szZrodlo << endl;
        }
    }
    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
