// DaneListyJed — przechowuj dane na jednokierunkowej liście obiektów
#include <cstdio>
#include <cstdlib>
#include <iostream>
using namespace std;
// DanaImienia — przechowuje imię osoby
//     (obiekty te mogą łatwo przechowywać dowolne
//     inne potrzebne informacje).
class DanaImienia
{
  public:
    string sImie;
    // wskaźnik do następnego elementu na liście
    DanaImienia* pNastepny;
};
// wskaźnik do pierwszego elementu na liście
DanaImienia* pGlowa = nullptr;
// dodaj — dodaj nowego członka do połączonej listy
void dodaj(DanaImienia* pNDS)
{
    // wskaż bieżący wpis na początku listy
    pNDS->pNastepny = pGlowa;
    // ustaw głowę listy na bieżący wpis
    pGlowa = pNDS;
}
// zbierzDane — przeczytaj imię i numer ubezpieczenia społecznego;
//     jeśli nie ma więcej do odczytania, zwróć wartość null
DanaImienia* zbierzDane()
{
    // odczytaj imię
    string imie;
    cout << "Wprowadź imię:";
    cin >> imie;
    // jeśli wprowadzona nazwa to „wyjdz” …
    if (imie == "wyjdz")
    {
        // …aby zakończyć wprowadzanie, zwróć wartość null
        return nullptr;
    }
    // pobierz nowy wpis i zapisz wartości
    DanaImienia* pNDS = new DanaImienia;
    pNDS->sImie = imie;
    pNDS->pNastepny = nullptr; // wskazanie na zero
    // zwróć adres utworzonego obiektu
    return pNDS;
}
int main(int nLiczbaArgumentow, char* pszArgs[])
{
    cout << "Wczytaj imiona uczniów\n"
        << "Wpisz „wyjdz” jako imię, aby zakończyć"
        << endl;
    // utwórz (inny) obiekt klasy DanaImienia
    DanaImienia* pNDS;
    while (pNDS = zbierzDane())
    {
        // dodaj go do listy obiektów klasy DanaImienia
        dodaj(pNDS);
    }
    // aby wyświetlić obiekty, iteruj przez listę
    //     (zakończ, gdy następny adres będzie równy NULL)
    cout << "\nWpisy:" << endl;
    for(DanaImienia *pIter = pGlowa; pIter;
                    pIter = pIter->pNastepny)
    {
        // wyświetl imię z bieżącego wpisu
        cout << pIter->sImie << endl;
    }
    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
