// AccountLinkedList - utrzymuje listę obiektów

#ifndef _ACCOUNTLINKEDLIST_
#define _ACCOUNTLINKEDLIST_

// ta niefortunna deklaracja wynika z tego, że klasa Account
// nie należy do przestrzeni nazw Lists. Ten problem rozwiązany
// jest w Budget4.
class Account;
namespace Lists
{
    // deklaracja klas z góry
    class AccountLinkedList;
    class Node;

    // LinkedList - reprezentuje listę węzłów
    class AccountLinkedList
    {
        public:
          AccountLinkedList() { pHead = 0; }
          void  addNode(Node* pNode);
          Node* firstNode() { return pHead; }

        protected:
          Node* pHead;
    };

    // Node - węzeł na liście; każdy węzeł wskazuje na obiekt typu Account
    class Node
    {
        friend class AccountLinkedList;
      public:
        Node(AccountLinkedList* pL, Account* pAcc)
        {
            pList = pL;
            pNext = 0;
            pAccount = pAcc;

            pL->addNode(this);
        }
        static Node* firstNode(AccountLinkedList* pList)
        {
            return pList->firstNode();
        }

        Node* nextNode() { return pNext; }
        Account* currentAccount() { return pAccount; }

      protected:
        AccountLinkedList* pList;
        Node* pNext;
        Account* pAccount;
    };
}
#endif
