/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <set>
#include <list>
#include <algorithm>
#include "print.hpp"
using namespace std;

int main()
{
    set<int> coll;

    // utworz wstawiacz dla kontenera coll
    // - niewygodny sposob
    insert_iterator<set<int> > iter(coll,coll.begin());

    // wstaw elementy z wykorzystaniem typowego interfejsu iteratora
    *iter = 1;
    iter++;
    *iter = 2;
    iter++;
    *iter = 3;

    PRINT_ELEMENTS(coll,"zbior:  ");

    // utworz wstawiacz i wstaw elementy
    // - wygodny sposob
    inserter(coll,coll.end()) = 44;
    inserter(coll,coll.end()) = 55;

    PRINT_ELEMENTS(coll,"zbior:  ");

    // uzyj wstawiacza do wstawienia wszystkich elementow do listy
    list<int> coll2;
    copy (coll.begin(), coll.end(),           // zrodlo
          inserter(coll2,coll2.begin()));     // przeznaczenie

    PRINT_ELEMENTS(coll2,"lista: ");

    // uzyj wstawiacza do ponownego wstawienia wszystkich elementow do listy przed drugim elementem
    copy (coll.begin(), coll.end(),           // zrodlo
          inserter(coll2,++coll2.begin()));   // przeznaczenie

    PRINT_ELEMENTS(coll2,"lista: ");
}
