/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <fstream>
using namespace std;

void redirect(ostream&);

int main()
{
    cout << "pierwszy wiersz" << endl;

    redirect(cout);

    cout << "ostatni wiersz" << endl;
}

void redirect (ostream& strm)
{
    ofstream file("redirect.txt");
    
    // zachowaj bufor wyjsciowy strumienia
    streambuf* strm_buffer = strm.rdbuf();

    // przekieruj strumien wyjsciowy do pliku
    strm.rdbuf (file.rdbuf());

    file << "jeden wiersz do pliku" << endl;
    strm << "jeden wiersz do strumienia" << endl;

    // przywroc stary bufor wyjsciowy
    strm.rdbuf (strm_buffer);

}    // plik oraz jego bufor zamykany jest automatycznie
