/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <locale>
#include <iostream>
#include <cstdlib>
#include <iterator>

int main()
{
    // utowrz kopie biezacego globalnego obiektu locale
    std::locale loc;

    // iterator sluzacy do odczytu ze standardowego wejscia
    typedef std::istreambuf_iterator<char> InIt;
    InIt beg = InIt(std::cin);
    InIt end = InIt();

    // strumien definiujacy format danych wejsciowych
    std::ios_base& fmt = std::cin;

    // zadeklaruj argumenty wyjsciowe
    std::ios_base::iostate err;
    float value;

    // pobierz z obiektu loc aspekt okreslajacy dane numeryczne 
    std::num_get<char, InIt> const& ng
      = std::use_facet<std::num_get<char, InIt> >(loc);

    // odczytaj wartosc przy uzyciu aspektu okreslajacego dane numeryczne
    ng.get(beg, end, fmt, err, value);

    // wyswietl wartosc lub komunikat o wystapieniu bledu
    if (err == std::ios_base::goodbit) {
        std::cout << "wartosc: " << value << '\n';
    }
    else if (err == std::ios_base::eofbit) {
        std::cout << "wartosc: " << value << " (napotkano znak EOF)\n";
    }
    else if (err & std::ios_base::badbit) {
        std::cerr << "podczas odczytywania wartosci numerycznej wystapil blad krytyczny\n";
        return EXIT_FAILURE;
    }
    else if (err & std::ios_base::failbit) {
        std::cerr << "podczas odczytywania wartosci numerycznej wystapil blad formatowania\n";
        return EXIT_FAILURE;
    }
}
