/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    /* inicjalizuj kolekcje zrodlowa ciagiem "..........abcdef.........."
     */
    vector<char> source(10,'.');
    for (int c='a'; c<='f'; c++) {
        source.push_back(c);
    }
    source.insert(source.end(),10,'.');
    PRINT_ELEMENTS(source,"zrodlo: ");

    // kopiuj wszystkie litery na trzecia pozycje przed elementem 'a'
    vector<char> c1(source.begin(),source.end());
    copy (c1.begin()+10, c1.begin()+16,  // zakres zrodlowy
          c1.begin()+7);                 // zakres docelowy
    PRINT_ELEMENTS(c1,"c1:     ");

    // kopiuj wszystkie litery na trzecia pozycje za elementem 'f'
    vector<char> c2(source.begin(),source.end());
    copy_backward (c2.begin()+10, c2.begin()+16,  // zakres zrodlowy
                   c2.begin()+19);                // zakres docelowy
    PRINT_ELEMENTS(c2,"c2:     ");
}
