#include <iostream>
#include <string.h>

class String
{
public:
    // Konstruktory.
    String();
    String(const char *const);
    String(const String&);
    ~String();

    // Przeciążone operatory.
    char& operator[](int offset);
    char operator[](int offset) const;
    String operator+(const String&);
    void operator+=(const String&);
    String& operator= (const String &);

    // Ogólne akcesory..
    int getLen() const { return len; }
    const char* getString() const { return value; }
    static int constructorCount;

private:
    String(int); // Konstruktor prywatny.
    char* value;
    int len;
};

// Konstruktor domyślny tworzy ciąg tekstowy o wielkości 0 bajtów.
String::String()
{
    value = new char[1];
    value[0] = '\0';
    len = 0;
    // std::cout << "\tKonstruktor domyślny ciągu tekstowego.\n";
    // constructorCount++;
}

// Konstruktor prywatny (pomocniczy) używany jedynie
// przez metody klasy w celu utworzenia nowego ciągu tekstowego
// o podanej wielkości. Wypełniony wartościami null.
String::String(int len)
{
    value = new char[len + 1];
    int i;
    for (i = 0; i < len; i++)
        value[i] = '\0';
    len = len;
    // std::cout << "\tKonstruktor String(int).\n";
    // constructorCount++;
}

String::String(const char* const cString)
{
    len = strlen(cString);
    value = new char[len + 1];
    int i;
    for (i = 0; i < len; i++)
       value[i] = cString[i];
    value[len] = '\0';
    // std::cout << "\tKonstruktor (char*).\n";
    // constructorCount++;
}

String::String(const String& rhs)
{
    len = rhs.getLen();
    value = new char[len + 1];
    int i;
    for (i = 0; i < len; i++)
        value[i] = rhs[i];
    value[len] = '\0';
    // std::cout << "\tKonstruktor String(String&).\n";
    // constructorCount++;
}

String::~String()
{
    delete [] value;
    len = 0;
    // std::cout << "\tDestruktor String.\n";
}

// Operator równości zwalnia zarezerwowaną pamięć,
// a następnie kopiuje ciąg tekstowy i wielkość.
String& String::operator=(const String &rhs)
{
    if (this == &rhs)
        return *this;
    delete [] value;
    len = rhs.getLen();
    value = new char[len + 1];
    int i;
    for (i = 0; i < len; i++)
        value[i] = rhs[i];
    value[len] = '\0';
    return *this;
    // std::cout << "\toperator=\n";
}

// Niebędący stałą operator, zwraca
// referencję do znaku, aby można go było
// zmienić!
char& String::operator[](int offset)
{
    if (offset > len)
        return value[len - 1];
    else
        return value[offset];
}

// Będący stałą operator przeznaczony do użycia
// w obiektach stałych (patrz konstruktor kopiujący!)
char String::operator[](int offset) const
{
    if (offset > len)
        return value[len-1];
    else
        return value[offset];
}

// Tworzy nowy ciąg tekstowy przez dodanie
// bieżącego do rhs.
String String::operator+(const String& rhs)
{
    int totalLen = len + rhs.getLen();
    int i, j;
    String temp(totalLen);
    for (i = 0; i < len; i++)
        temp[i] = value[i];
    for (j = 0; j < rhs.getLen(); j++, i++)
        temp[i] = rhs[j];
    temp[totalLen] = '\0';
    return temp;
}

// Zmienia bieżący ciąg tekstowy, niczego nie zwraca.
void String::operator+=(const String& rhs)
{
    int rhsLen = rhs.getLen();
    int totalLen = len + rhsLen;
    int i, j;
    String temp(totalLen);
    for (i = 0; i < len; i++)
        temp[i] = value[i];
    for (j = 0; j < rhs.getLen(); j++, i++)
        temp[i] = rhs[i - len];
    temp[totalLen] = '\0';
    *this = temp;
}

// int String::constructorCount = 0;
