#include <iostream>

int main()
{
    /* Lambda z natychmiastowym wywołaniem poprzez () */
    [] { std::cout << "Hello!" << std::endl; }();
  
    /* Lambda o nazwie „lambda” */
    auto lambda = []() { std::cout << "Hallo!" << std::endl; };
  
    /* i wywołanie lambdy o nazwie „lambda”. */
    lambda();
  
    /* Lambda o nazwie „add” przyjmująca dwa argumenty
       (int a, int b) i zwracająca ich sumę. */
    auto add = [](int a, int b) { return a + b; };
  
    /* Wywołanie lambdy „add” */
    std::cout << "2 + 2 = " << add(2, 2) << std::endl;
  
    /* Lambda bez nazwy, co przyjmuje argument (int i)
       oraz zwiększa jego wartość o jeden. Następuje 
       tutaj natychmiastowe wywołanie lambdy z argumentem
       o wartości 1 i przypisanie wyniku do zmiennej „r”. */
    int r = [](int i) { return i + 1; }(1);
  
    std::cout << "r = " << r << std::endl;
  
    return EXIT_SUCCESS;
}
