#include <iostream>

int main()
{
    /* Definicja zmiennej typu „int” o wartości
       początkowej siedem (7). */
    int value { 7 };
  
    /* Odwołanie (referencja, znak &) do zmiennej
       „value” z modyfikatorem „const”. */
    const int& numConst { value };
  
    /* Błąd: Nie możemy przypisać nowej wartości
             do stałej (const). */
    //numConst = 8;
  
    /* Usuwamy modyfikator „const” z odwołania
       (referencji) „numConst”, aby mieć możliwość
       zapisu (modyfikacji wartości). Następuje
       tutaj konwersja z „const int&” na „int&” */
    int& num = const_cast<int&>(numConst);
  
    /* Może się wydawać, że nadajemy nową wartość
       dla „num”, jednak są to tylko odwołania
       (referencje), a modyfikujemy wartość
       zmiennej „value” [!]. */
    num = 128;
  
    /* Nazwy „num” i „numConst” są odwołaniami do
       zmiennej „value”, a nie jej kopią.
       Dlatego, gdy przypiszemy wartość do „num”,
       to zmodyfikowana zostanie zmienna „value”. */
    std::cout << "num = "      << num << std::endl; //128
    std::cout << "numConst = " << numConst << std::endl; //128
    std::cout << "value = "    << value << std::endl; //128
  
    return EXIT_SUCCESS;
}
