#include <iostream>
#include <vector>
#include <array>
#include <numeric> // Wymagany przez klasę std::iota.

int main()
{
    constexpr size_t container_size {1000};

#if 0
    std::vector<int> v (container_size);

    // Wypełnienie wektora liczbami rosnącymi.
    std::iota(std::begin(v), std::end(v), 0);

    // Istnieje prawdopodobieństwo, że poniższy wiersz nie doprowadzi do awarii programu...
    std::cout << "Wartość elementu nieznajdującego się w wektorze: "
              << v[container_size + 10] << "\n";

    try {
        // Próba uzyskania dostępu do wartości nieznajdującej się w wektorze PROWADZI do zgłoszenia wyjątku...
        std::cout << "Wartość elementu nieznajdującego się w wektorze: "
                  << v.at(container_size + 10) << "\n";

    } catch (const std::out_of_range &e) {
        // ...który zostanie w tym miejscu obsłużony.
        std::cout << "Ups, wykryto próbę uzyskania dostępu do nieistniejącego elementu wektora: "
                  << e.what() << "\n";
    }
#endif

    // Te same metody dostępu i reguły mają zastosowanie także dla std::array.
    std::array<int, container_size> a;

    // Wypełnienie wektora liczbami rosnącymi
    std::iota(std::begin(a), std::end(a), 0);

    // Istnieje prawdopodobieństwo, że poniższy wiersz nie doprowadzi do awarii programu...
    std::cout << "Wartość elementu nieznajdującego się w wektorze: "
              << a[container_size + 10] << "\n";

#if 0
    try {
#endif
        // Próba uzyskania dostępu do wartości nieznajdującej się w wektorze PROWADZI do zgłoszenia wyjątku...
        std::cout << "Wartość elementu nieznajdującego się w wektorze: "
                  << a.at(container_size + 10) << "\n";

#if 0
    } catch (const std::out_of_range &e) {
        // ...który zostanie w tym miejscu obsłużony.
        std::cout << "Ups, wykryto próbę uzyskania dostępu do nieistniejącego elementu wektora: "
                  << e.what() << "\n";
    }
#endif
}
