#include <algorithm>
#include <cctype>
#include "Str.h"
#include "Vec.h"

#include "urls.h"

using std::find;
using std::find_if;

#ifndef _MSC_VER
using std::isalnum;
using std::isalpha;
using std::isdigit;
#endif

using std::search;



bool not_url_char(char);

Str::const_iterator
url_end(Str::const_iterator, Str::const_iterator);

Str::const_iterator
url_beg(Str::const_iterator, Str::const_iterator);
Vec<Str> find_urls(const Str& s)
{
	Vec<Str> ret;
	typedef Str::const_iterator iter;
	iter b = s.begin(), e = s.end();

	// przejrzyj cay cig wejciowy
	while (b != e) {

		// poszukaj jednego lub kilku znakw, po ktrych znajduje si podcig ://
		b = url_beg(b, e);

		// jeli udao si znale podcig
		if (b != e) {
			// pobierz reszt URL-a
			iter after = url_end(b, e);

			// zapamitaj znaleziony URL
			ret.push_back(Str(b, after));

			// zwiksz b i szukaj nastpnych identyfikatorw
			b = after;
		}
	}
	return ret;
}

Str::const_iterator
url_end(Str::const_iterator b, Str::const_iterator e)
{
	return find_if(b, e, not_url_char);
}

bool not_url_char(char c)
{
	// znaki (poza znakami alfanumerycznymi) dozwolone w identyfikatorach URL
	static const Str url_ch = "~;/?:@=&$-_.+!*'(),";

	// sprawd, czy c jest dozwolonym znakiem URL
	return !(isalnum(c) ||
	         find(url_ch.begin(), url_ch.end(), c) != url_ch.end());
}

Str::const_iterator
url_beg(Str::const_iterator b, Str::const_iterator e)
{
	static const Str sep = "://";

	typedef Str::const_iterator iter;

	// i sygnalizuje odnalezienie separatora ://
	iter i = b;

	while ((i = search(i, e, sep.begin(), sep.end())) != e) {

		// upewnij si, e separator nie rozpoczyna si od pocztku cigu
		if (i != b && i + sep.size() != e) {

			// beg zaznacza pocztek nazwy-protokou
			iter beg = i;
			while (beg != b && isalpha(beg[-1]))
				--beg;

			// czy za i przed separatorem :// znajduje si przynajmniej po jednym znaku?
			if (beg != i && !not_url_char(i[sep.size()]))
				return beg;
		}

		// odnaleziony separator nie jest czci URL-a; zwiksz i poza pozycj ostatniego znaku sepraratora
		i += sep.size();
	}
	return e;
}

